@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.inputs

import com.pulumi.aws.dms.inputs.EndpointMongodbSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authMechanism Authentication mechanism to access the MongoDB source endpoint. Default is `default`.
 * @property authSource Authentication database name. Not used when `auth_type` is `no`. Default is `admin`.
 * @property authType Authentication type to access the MongoDB source endpoint. Default is `password`.
 * @property docsToInvestigate Number of documents to preview to determine the document organization. Use this setting when `nesting_level` is set to `one`. Default is `1000`.
 * @property extractDocId Document ID. Use this setting when `nesting_level` is set to `none`. Default is `false`.
 * @property nestingLevel Specifies either document or table mode. Default is `none`. Valid values are `one` (table mode) and `none` (document mode).
 */
public data class EndpointMongodbSettingsArgs(
    public val authMechanism: Output<String>? = null,
    public val authSource: Output<String>? = null,
    public val authType: Output<String>? = null,
    public val docsToInvestigate: Output<String>? = null,
    public val extractDocId: Output<String>? = null,
    public val nestingLevel: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.inputs.EndpointMongodbSettingsArgs> {
    override fun toJava(): com.pulumi.aws.dms.inputs.EndpointMongodbSettingsArgs =
        com.pulumi.aws.dms.inputs.EndpointMongodbSettingsArgs.builder()
            .authMechanism(authMechanism?.applyValue({ args0 -> args0 }))
            .authSource(authSource?.applyValue({ args0 -> args0 }))
            .authType(authType?.applyValue({ args0 -> args0 }))
            .docsToInvestigate(docsToInvestigate?.applyValue({ args0 -> args0 }))
            .extractDocId(extractDocId?.applyValue({ args0 -> args0 }))
            .nestingLevel(nestingLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointMongodbSettingsArgs].
 */
@PulumiTagMarker
public class EndpointMongodbSettingsArgsBuilder internal constructor() {
    private var authMechanism: Output<String>? = null

    private var authSource: Output<String>? = null

    private var authType: Output<String>? = null

    private var docsToInvestigate: Output<String>? = null

    private var extractDocId: Output<String>? = null

    private var nestingLevel: Output<String>? = null

    /**
     * @param value Authentication mechanism to access the MongoDB source endpoint. Default is `default`.
     */
    @JvmName("wovbolwxlehknpcb")
    public suspend fun authMechanism(`value`: Output<String>) {
        this.authMechanism = value
    }

    /**
     * @param value Authentication database name. Not used when `auth_type` is `no`. Default is `admin`.
     */
    @JvmName("ujqfhqqtebgcgnjc")
    public suspend fun authSource(`value`: Output<String>) {
        this.authSource = value
    }

    /**
     * @param value Authentication type to access the MongoDB source endpoint. Default is `password`.
     */
    @JvmName("gjpmkbnidoqmqfrm")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Number of documents to preview to determine the document organization. Use this setting when `nesting_level` is set to `one`. Default is `1000`.
     */
    @JvmName("rtsktagrttbfffwn")
    public suspend fun docsToInvestigate(`value`: Output<String>) {
        this.docsToInvestigate = value
    }

    /**
     * @param value Document ID. Use this setting when `nesting_level` is set to `none`. Default is `false`.
     */
    @JvmName("ajosroabgmmdjvom")
    public suspend fun extractDocId(`value`: Output<String>) {
        this.extractDocId = value
    }

    /**
     * @param value Specifies either document or table mode. Default is `none`. Valid values are `one` (table mode) and `none` (document mode).
     */
    @JvmName("pxrkgscvkcvowpag")
    public suspend fun nestingLevel(`value`: Output<String>) {
        this.nestingLevel = value
    }

    /**
     * @param value Authentication mechanism to access the MongoDB source endpoint. Default is `default`.
     */
    @JvmName("ipbysqnpnalwftsg")
    public suspend fun authMechanism(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authMechanism = mapped
    }

    /**
     * @param value Authentication database name. Not used when `auth_type` is `no`. Default is `admin`.
     */
    @JvmName("qfugfamqnrehcbuo")
    public suspend fun authSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authSource = mapped
    }

    /**
     * @param value Authentication type to access the MongoDB source endpoint. Default is `password`.
     */
    @JvmName("npohirykjgqocqfi")
    public suspend fun authType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Number of documents to preview to determine the document organization. Use this setting when `nesting_level` is set to `one`. Default is `1000`.
     */
    @JvmName("wehsijthabqilhuk")
    public suspend fun docsToInvestigate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.docsToInvestigate = mapped
    }

    /**
     * @param value Document ID. Use this setting when `nesting_level` is set to `none`. Default is `false`.
     */
    @JvmName("tnewomamhhlthera")
    public suspend fun extractDocId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extractDocId = mapped
    }

    /**
     * @param value Specifies either document or table mode. Default is `none`. Valid values are `one` (table mode) and `none` (document mode).
     */
    @JvmName("ttyibjxlbvtgkdct")
    public suspend fun nestingLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nestingLevel = mapped
    }

    internal fun build(): EndpointMongodbSettingsArgs = EndpointMongodbSettingsArgs(
        authMechanism = authMechanism,
        authSource = authSource,
        authType = authType,
        docsToInvestigate = docsToInvestigate,
        extractDocId = extractDocId,
        nestingLevel = nestingLevel,
    )
}
