@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.inputs

import com.pulumi.aws.dms.inputs.EndpointRedisSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authPassword The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
 * @property authType The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
 * @property authUserName The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
 * @property port Transmission Control Protocol (TCP) port for the endpoint.
 * @property serverName Fully qualified domain name of the endpoint.
 * @property sslCaCertificateArn The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
 * @property sslSecurityProtocol The plaintext option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
 */
public data class EndpointRedisSettingsArgs(
    public val authPassword: Output<String>? = null,
    public val authType: Output<String>,
    public val authUserName: Output<String>? = null,
    public val port: Output<Int>,
    public val serverName: Output<String>,
    public val sslCaCertificateArn: Output<String>? = null,
    public val sslSecurityProtocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.inputs.EndpointRedisSettingsArgs> {
    override fun toJava(): com.pulumi.aws.dms.inputs.EndpointRedisSettingsArgs =
        com.pulumi.aws.dms.inputs.EndpointRedisSettingsArgs.builder()
            .authPassword(authPassword?.applyValue({ args0 -> args0 }))
            .authType(authType.applyValue({ args0 -> args0 }))
            .authUserName(authUserName?.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .serverName(serverName.applyValue({ args0 -> args0 }))
            .sslCaCertificateArn(sslCaCertificateArn?.applyValue({ args0 -> args0 }))
            .sslSecurityProtocol(sslSecurityProtocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointRedisSettingsArgs].
 */
@PulumiTagMarker
public class EndpointRedisSettingsArgsBuilder internal constructor() {
    private var authPassword: Output<String>? = null

    private var authType: Output<String>? = null

    private var authUserName: Output<String>? = null

    private var port: Output<Int>? = null

    private var serverName: Output<String>? = null

    private var sslCaCertificateArn: Output<String>? = null

    private var sslSecurityProtocol: Output<String>? = null

    /**
     * @param value The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
     */
    @JvmName("rkbbhrdvxtqgjexy")
    public suspend fun authPassword(`value`: Output<String>) {
        this.authPassword = value
    }

    /**
     * @param value The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
     */
    @JvmName("ypevwqnndbhhxxdq")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
     */
    @JvmName("ciniwydpdgfpsbtj")
    public suspend fun authUserName(`value`: Output<String>) {
        this.authUserName = value
    }

    /**
     * @param value Transmission Control Protocol (TCP) port for the endpoint.
     */
    @JvmName("nnrbkcnnybcmwhns")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Fully qualified domain name of the endpoint.
     */
    @JvmName("fditfolvecimilab")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
     */
    @JvmName("wadnapymhtalkdoj")
    public suspend fun sslCaCertificateArn(`value`: Output<String>) {
        this.sslCaCertificateArn = value
    }

    /**
     * @param value The plaintext option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
     */
    @JvmName("jiphfybgmbtdtcav")
    public suspend fun sslSecurityProtocol(`value`: Output<String>) {
        this.sslSecurityProtocol = value
    }

    /**
     * @param value The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
     */
    @JvmName("hbllrcplgqohlkhv")
    public suspend fun authPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authPassword = mapped
    }

    /**
     * @param value The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
     */
    @JvmName("edpntobhnaqednsr")
    public suspend fun authType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
     */
    @JvmName("dbmccliegfmfxipr")
    public suspend fun authUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authUserName = mapped
    }

    /**
     * @param value Transmission Control Protocol (TCP) port for the endpoint.
     */
    @JvmName("ybuiihrlfrostxje")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Fully qualified domain name of the endpoint.
     */
    @JvmName("dmfuidcwqabyxauq")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
     */
    @JvmName("jmdfaahqbdwwmlpo")
    public suspend fun sslCaCertificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCaCertificateArn = mapped
    }

    /**
     * @param value The plaintext option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
     */
    @JvmName("joxtrdvnpwteknpc")
    public suspend fun sslSecurityProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslSecurityProtocol = mapped
    }

    internal fun build(): EndpointRedisSettingsArgs = EndpointRedisSettingsArgs(
        authPassword = authPassword,
        authType = authType ?: throw PulumiNullFieldException("authType"),
        authUserName = authUserName,
        port = port ?: throw PulumiNullFieldException("port"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        sslCaCertificateArn = sslCaCertificateArn,
        sslSecurityProtocol = sslSecurityProtocol,
    )
}
