@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.inputs

import com.pulumi.aws.dms.inputs.EndpointRedshiftSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketFolder Custom S3 Bucket Object prefix for intermediate storage.
 * @property bucketName Custom S3 Bucket name for intermediate storage.
 * @property encryptionMode The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
 * @property serverSideEncryptionKmsKeyId ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
 * @property serviceAccessRoleArn Amazon Resource Name (ARN) of the IAM Role with permissions to read from or write to the S3 Bucket for intermediate storage.
 */
public data class EndpointRedshiftSettingsArgs(
    public val bucketFolder: Output<String>? = null,
    public val bucketName: Output<String>? = null,
    public val encryptionMode: Output<String>? = null,
    public val serverSideEncryptionKmsKeyId: Output<String>? = null,
    public val serviceAccessRoleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.inputs.EndpointRedshiftSettingsArgs> {
    override fun toJava(): com.pulumi.aws.dms.inputs.EndpointRedshiftSettingsArgs =
        com.pulumi.aws.dms.inputs.EndpointRedshiftSettingsArgs.builder()
            .bucketFolder(bucketFolder?.applyValue({ args0 -> args0 }))
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .encryptionMode(encryptionMode?.applyValue({ args0 -> args0 }))
            .serverSideEncryptionKmsKeyId(serverSideEncryptionKmsKeyId?.applyValue({ args0 -> args0 }))
            .serviceAccessRoleArn(serviceAccessRoleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointRedshiftSettingsArgs].
 */
@PulumiTagMarker
public class EndpointRedshiftSettingsArgsBuilder internal constructor() {
    private var bucketFolder: Output<String>? = null

    private var bucketName: Output<String>? = null

    private var encryptionMode: Output<String>? = null

    private var serverSideEncryptionKmsKeyId: Output<String>? = null

    private var serviceAccessRoleArn: Output<String>? = null

    /**
     * @param value Custom S3 Bucket Object prefix for intermediate storage.
     */
    @JvmName("pxshsmxrvdpngpsa")
    public suspend fun bucketFolder(`value`: Output<String>) {
        this.bucketFolder = value
    }

    /**
     * @param value Custom S3 Bucket name for intermediate storage.
     */
    @JvmName("lsaqgsijuxfpviqp")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
     */
    @JvmName("wyydychvkhoigmqq")
    public suspend fun encryptionMode(`value`: Output<String>) {
        this.encryptionMode = value
    }

    /**
     * @param value ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
     */
    @JvmName("eggpnyyyddtsfevr")
    public suspend fun serverSideEncryptionKmsKeyId(`value`: Output<String>) {
        this.serverSideEncryptionKmsKeyId = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role with permissions to read from or write to the S3 Bucket for intermediate storage.
     */
    @JvmName("gggupjcofwfjlclj")
    public suspend fun serviceAccessRoleArn(`value`: Output<String>) {
        this.serviceAccessRoleArn = value
    }

    /**
     * @param value Custom S3 Bucket Object prefix for intermediate storage.
     */
    @JvmName("fjvpxqyytbijwmxh")
    public suspend fun bucketFolder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketFolder = mapped
    }

    /**
     * @param value Custom S3 Bucket name for intermediate storage.
     */
    @JvmName("kfllyylvsyqsnckd")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
     */
    @JvmName("ccatokfcmstkcuxm")
    public suspend fun encryptionMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionMode = mapped
    }

    /**
     * @param value ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
     */
    @JvmName("mrioclcrurdykjau")
    public suspend fun serverSideEncryptionKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryptionKmsKeyId = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role with permissions to read from or write to the S3 Bucket for intermediate storage.
     */
    @JvmName("ootllmmscsflbmvk")
    public suspend fun serviceAccessRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccessRoleArn = mapped
    }

    internal fun build(): EndpointRedshiftSettingsArgs = EndpointRedshiftSettingsArgs(
        bucketFolder = bucketFolder,
        bucketName = bucketName,
        encryptionMode = encryptionMode,
        serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId,
        serviceAccessRoleArn = serviceAccessRoleArn,
    )
}
