@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.inputs

import com.pulumi.aws.dms.inputs.GetEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEndpoint.
 * @property endpointId Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
 * @property tags
 */
public data class GetEndpointPlainArgs(
    public val endpointId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.inputs.GetEndpointPlainArgs> {
    override fun toJava(): com.pulumi.aws.dms.inputs.GetEndpointPlainArgs =
        com.pulumi.aws.dms.inputs.GetEndpointPlainArgs.builder()
            .endpointId(endpointId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetEndpointPlainArgsBuilder internal constructor() {
    private var endpointId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
     */
    @JvmName("bcetnaihybmkhjeb")
    public suspend fun endpointId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointId = mapped
    }

    /**
     * @param value
     */
    @JvmName("vpmawqaouxmbgaht")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("egwsxaexbdxaagnp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetEndpointPlainArgs = GetEndpointPlainArgs(
        endpointId = endpointId ?: throw PulumiNullFieldException("endpointId"),
        tags = tags,
    )
}
