@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.inputs

import com.pulumi.aws.dms.inputs.GetReplicationTaskPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReplicationTask.
 * @property replicationTaskId The replication task identifier.
 * - Must contain from 1 to 255 alphanumeric characters or hyphens.
 * - First character must be a letter.
 * - Cannot end with a hyphen.
 * - Cannot contain two consecutive hyphens.
 * @property tags
 */
public data class GetReplicationTaskPlainArgs(
    public val replicationTaskId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.inputs.GetReplicationTaskPlainArgs> {
    override fun toJava(): com.pulumi.aws.dms.inputs.GetReplicationTaskPlainArgs =
        com.pulumi.aws.dms.inputs.GetReplicationTaskPlainArgs.builder()
            .replicationTaskId(replicationTaskId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetReplicationTaskPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationTaskPlainArgsBuilder internal constructor() {
    private var replicationTaskId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The replication task identifier.
     * - Must contain from 1 to 255 alphanumeric characters or hyphens.
     * - First character must be a letter.
     * - Cannot end with a hyphen.
     * - Cannot contain two consecutive hyphens.
     */
    @JvmName("gynekhefqbaanjil")
    public suspend fun replicationTaskId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.replicationTaskId = mapped
    }

    /**
     * @param value
     */
    @JvmName("tqjwamdashpgjmce")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("rugixaelrpnjftdx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetReplicationTaskPlainArgs = GetReplicationTaskPlainArgs(
        replicationTaskId = replicationTaskId ?: throw PulumiNullFieldException("replicationTaskId"),
        tags = tags,
    )
}
