@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.inputs

import com.pulumi.aws.dms.inputs.ReplicationConfigComputeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityZone The Availability Zone where the DMS Serverless replication using this configuration will run. The default value is a random.
 * @property dnsNameServers A list of custom DNS name servers supported for the DMS Serverless replication to access your source or target database.
 * @property kmsKeyId An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during DMS Serverless replication. If you don't specify a value for the KmsKeyId parameter, DMS uses your default encryption key.
 * @property maxCapacityUnits Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 2 DCUs as the minimum value allowed. The list of valid DCU values includes 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384.
 * @property minCapacityUnits Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. The list of valid DCU values includes 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. If this value isn't set DMS scans the current activity of available source tables to identify an optimum setting for this parameter.
 * @property multiAz Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
 * @property preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
 * - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
 * - Format: `ddd:hh24:mi-ddd:hh24:mi`
 * - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
 * - Constraints: Minimum 30-minute window.
 * @property replicationSubnetGroupId Specifies a subnet group identifier to associate with the DMS Serverless replication.
 * @property vpcSecurityGroupIds Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
 */
public data class ReplicationConfigComputeConfigArgs(
    public val availabilityZone: Output<String>? = null,
    public val dnsNameServers: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val maxCapacityUnits: Output<Int>? = null,
    public val minCapacityUnits: Output<Int>? = null,
    public val multiAz: Output<Boolean>? = null,
    public val preferredMaintenanceWindow: Output<String>? = null,
    public val replicationSubnetGroupId: Output<String>,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.inputs.ReplicationConfigComputeConfigArgs> {
    override fun toJava(): com.pulumi.aws.dms.inputs.ReplicationConfigComputeConfigArgs =
        com.pulumi.aws.dms.inputs.ReplicationConfigComputeConfigArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .dnsNameServers(dnsNameServers?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .maxCapacityUnits(maxCapacityUnits?.applyValue({ args0 -> args0 }))
            .minCapacityUnits(minCapacityUnits?.applyValue({ args0 -> args0 }))
            .multiAz(multiAz?.applyValue({ args0 -> args0 }))
            .preferredMaintenanceWindow(preferredMaintenanceWindow?.applyValue({ args0 -> args0 }))
            .replicationSubnetGroupId(replicationSubnetGroupId.applyValue({ args0 -> args0 }))
            .vpcSecurityGroupIds(
                vpcSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ReplicationConfigComputeConfigArgs].
 */
@PulumiTagMarker
public class ReplicationConfigComputeConfigArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var dnsNameServers: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var maxCapacityUnits: Output<Int>? = null

    private var minCapacityUnits: Output<Int>? = null

    private var multiAz: Output<Boolean>? = null

    private var preferredMaintenanceWindow: Output<String>? = null

    private var replicationSubnetGroupId: Output<String>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    /**
     * @param value The Availability Zone where the DMS Serverless replication using this configuration will run. The default value is a random.
     */
    @JvmName("sufhlkvpiycteerg")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value A list of custom DNS name servers supported for the DMS Serverless replication to access your source or target database.
     */
    @JvmName("ftorllkkrcjhdlwq")
    public suspend fun dnsNameServers(`value`: Output<String>) {
        this.dnsNameServers = value
    }

    /**
     * @param value An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during DMS Serverless replication. If you don't specify a value for the KmsKeyId parameter, DMS uses your default encryption key.
     */
    @JvmName("sjxrjqbtkbcaatwo")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 2 DCUs as the minimum value allowed. The list of valid DCU values includes 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384.
     */
    @JvmName("smlvwqidxcakgiod")
    public suspend fun maxCapacityUnits(`value`: Output<Int>) {
        this.maxCapacityUnits = value
    }

    /**
     * @param value Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. The list of valid DCU values includes 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. If this value isn't set DMS scans the current activity of available source tables to identify an optimum setting for this parameter.
     */
    @JvmName("ckmcmrissaiyrryy")
    public suspend fun minCapacityUnits(`value`: Output<Int>) {
        this.minCapacityUnits = value
    }

    /**
     * @param value Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
     */
    @JvmName("cykfiidaxvjropct")
    public suspend fun multiAz(`value`: Output<Boolean>) {
        this.multiAz = value
    }

    /**
     * @param value The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
     * - Format: `ddd:hh24:mi-ddd:hh24:mi`
     * - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
     * - Constraints: Minimum 30-minute window.
     */
    @JvmName("bnbvvmwevaubfmnu")
    public suspend fun preferredMaintenanceWindow(`value`: Output<String>) {
        this.preferredMaintenanceWindow = value
    }

    /**
     * @param value Specifies a subnet group identifier to associate with the DMS Serverless replication.
     */
    @JvmName("xsgshhyslqbvvond")
    public suspend fun replicationSubnetGroupId(`value`: Output<String>) {
        this.replicationSubnetGroupId = value
    }

    /**
     * @param value Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
     */
    @JvmName("erxqoyqtxtmremhp")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("gbcypkxtefbycfaw")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
     */
    @JvmName("cajamoxcbntjbhmf")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value The Availability Zone where the DMS Serverless replication using this configuration will run. The default value is a random.
     */
    @JvmName("cxeiplcyyjqxxftu")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value A list of custom DNS name servers supported for the DMS Serverless replication to access your source or target database.
     */
    @JvmName("phcnwrkkldknmfbm")
    public suspend fun dnsNameServers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsNameServers = mapped
    }

    /**
     * @param value An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during DMS Serverless replication. If you don't specify a value for the KmsKeyId parameter, DMS uses your default encryption key.
     */
    @JvmName("rxrvnalugfseonbj")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 2 DCUs as the minimum value allowed. The list of valid DCU values includes 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384.
     */
    @JvmName("wmhgjkwflkqjoqss")
    public suspend fun maxCapacityUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCapacityUnits = mapped
    }

    /**
     * @param value Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. The list of valid DCU values includes 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. If this value isn't set DMS scans the current activity of available source tables to identify an optimum setting for this parameter.
     */
    @JvmName("yneqkxksvbygaoka")
    public suspend fun minCapacityUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCapacityUnits = mapped
    }

    /**
     * @param value Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
     */
    @JvmName("igwyaifqfyvejqji")
    public suspend fun multiAz(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiAz = mapped
    }

    /**
     * @param value The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
     * - Format: `ddd:hh24:mi-ddd:hh24:mi`
     * - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
     * - Constraints: Minimum 30-minute window.
     */
    @JvmName("amuleclaavhwetem")
    public suspend fun preferredMaintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredMaintenanceWindow = mapped
    }

    /**
     * @param value Specifies a subnet group identifier to associate with the DMS Serverless replication.
     */
    @JvmName("pioxpmawcbuntwmo")
    public suspend fun replicationSubnetGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationSubnetGroupId = mapped
    }

    /**
     * @param value Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
     */
    @JvmName("lkafomtlgwfsbfly")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
     */
    @JvmName("tmufjhvpsvklitmu")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    internal fun build(): ReplicationConfigComputeConfigArgs = ReplicationConfigComputeConfigArgs(
        availabilityZone = availabilityZone,
        dnsNameServers = dnsNameServers,
        kmsKeyId = kmsKeyId,
        maxCapacityUnits = maxCapacityUnits,
        minCapacityUnits = minCapacityUnits,
        multiAz = multiAz,
        preferredMaintenanceWindow = preferredMaintenanceWindow,
        replicationSubnetGroupId = replicationSubnetGroupId ?: throw
            PulumiNullFieldException("replicationSubnetGroupId"),
        vpcSecurityGroupIds = vpcSecurityGroupIds,
    )
}
