@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpointUri Endpoint for the OpenSearch cluster.
 * @property errorRetryDuration Maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster. Default is `300`.
 * @property fullLoadErrorPercentage Maximum percentage of records that can fail to be written before a full load operation stops. Default is `10`.
 * @property serviceAccessRoleArn ARN of the IAM Role with permissions to write to the OpenSearch cluster.
 */
public data class EndpointElasticsearchSettings(
    public val endpointUri: String,
    public val errorRetryDuration: Int? = null,
    public val fullLoadErrorPercentage: Int? = null,
    public val serviceAccessRoleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.EndpointElasticsearchSettings):
            EndpointElasticsearchSettings = EndpointElasticsearchSettings(
            endpointUri = javaType.endpointUri(),
            errorRetryDuration = javaType.errorRetryDuration().map({ args0 -> args0 }).orElse(null),
            fullLoadErrorPercentage = javaType.fullLoadErrorPercentage().map({ args0 -> args0 }).orElse(null),
            serviceAccessRoleArn = javaType.serviceAccessRoleArn(),
        )
    }
}
