@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property broker Kafka broker location. Specify in the form broker-hostname-or-ip:port.
 * @property includeControlDetails Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. Default is `false`.
 * @property includeNullAndEmpty Include NULL and empty columns for records migrated to the endpoint. Default is `false`.
 * @property includePartitionValue Shows the partition value within the Kafka message output unless the partition type is `schema-table-type`. Default is `false`.
 * @property includeTableAlterOperations Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table`, `drop-table`, `add-column`, `drop-column`, and `rename-column`. Default is `false`.
 * @property includeTransactionDetails Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for `transaction_id`, previous `transaction_id`, and `transaction_record_id` (the record offset within a transaction). Default is `false`.
 * @property messageFormat Output format for the records created on the endpoint. Message format is `JSON` (default) or `JSON_UNFORMATTED` (a single line with no tab).
 * @property messageMaxBytes Maximum size in bytes for records created on the endpoint Default is `1,000,000`.
 * @property noHexPrefix Set this optional parameter to true to avoid adding a '0x' prefix to raw data in hexadecimal format. For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the `no_hex_prefix` endpoint setting to enable migration of RAW data type columns without adding the `'0x'` prefix.
 * @property partitionIncludeSchemaTable Prefixes schema and table names to partition values, when the partition type is `primary-key-type`. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. Default is `false`.
 * @property saslPassword Secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
 * @property saslUsername Secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
 * @property securityProtocol Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include `ssl-encryption`, `ssl-authentication`, and `sasl-ssl`. `sasl-ssl` requires `sasl_username` and `sasl_password`.
 * @property sslCaCertificateArn ARN for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
 * @property sslClientCertificateArn ARN of the client certificate used to securely connect to a Kafka target endpoint.
 * @property sslClientKeyArn ARN for the client private key used to securely connect to a Kafka target endpoint.
 * @property sslClientKeyPassword Password for the client private key used to securely connect to a Kafka target endpoint.
 * @property topic Kafka topic for migration. Default is `kafka-default-topic`.
 */
public data class EndpointKafkaSettings(
    public val broker: String,
    public val includeControlDetails: Boolean? = null,
    public val includeNullAndEmpty: Boolean? = null,
    public val includePartitionValue: Boolean? = null,
    public val includeTableAlterOperations: Boolean? = null,
    public val includeTransactionDetails: Boolean? = null,
    public val messageFormat: String? = null,
    public val messageMaxBytes: Int? = null,
    public val noHexPrefix: Boolean? = null,
    public val partitionIncludeSchemaTable: Boolean? = null,
    public val saslPassword: String? = null,
    public val saslUsername: String? = null,
    public val securityProtocol: String? = null,
    public val sslCaCertificateArn: String? = null,
    public val sslClientCertificateArn: String? = null,
    public val sslClientKeyArn: String? = null,
    public val sslClientKeyPassword: String? = null,
    public val topic: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.EndpointKafkaSettings):
            EndpointKafkaSettings = EndpointKafkaSettings(
            broker = javaType.broker(),
            includeControlDetails = javaType.includeControlDetails().map({ args0 -> args0 }).orElse(null),
            includeNullAndEmpty = javaType.includeNullAndEmpty().map({ args0 -> args0 }).orElse(null),
            includePartitionValue = javaType.includePartitionValue().map({ args0 -> args0 }).orElse(null),
            includeTableAlterOperations = javaType.includeTableAlterOperations().map({ args0 ->
                args0
            }).orElse(null),
            includeTransactionDetails = javaType.includeTransactionDetails().map({ args0 ->
                args0
            }).orElse(null),
            messageFormat = javaType.messageFormat().map({ args0 -> args0 }).orElse(null),
            messageMaxBytes = javaType.messageMaxBytes().map({ args0 -> args0 }).orElse(null),
            noHexPrefix = javaType.noHexPrefix().map({ args0 -> args0 }).orElse(null),
            partitionIncludeSchemaTable = javaType.partitionIncludeSchemaTable().map({ args0 ->
                args0
            }).orElse(null),
            saslPassword = javaType.saslPassword().map({ args0 -> args0 }).orElse(null),
            saslUsername = javaType.saslUsername().map({ args0 -> args0 }).orElse(null),
            securityProtocol = javaType.securityProtocol().map({ args0 -> args0 }).orElse(null),
            sslCaCertificateArn = javaType.sslCaCertificateArn().map({ args0 -> args0 }).orElse(null),
            sslClientCertificateArn = javaType.sslClientCertificateArn().map({ args0 -> args0 }).orElse(null),
            sslClientKeyArn = javaType.sslClientKeyArn().map({ args0 -> args0 }).orElse(null),
            sslClientKeyPassword = javaType.sslClientKeyPassword().map({ args0 -> args0 }).orElse(null),
            topic = javaType.topic().map({ args0 -> args0 }).orElse(null),
        )
    }
}
