@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authMechanism Authentication mechanism to access the MongoDB source endpoint. Default is `default`.
 * @property authSource Authentication database name. Not used when `auth_type` is `no`. Default is `admin`.
 * @property authType Authentication type to access the MongoDB source endpoint. Default is `password`.
 * @property docsToInvestigate Number of documents to preview to determine the document organization. Use this setting when `nesting_level` is set to `one`. Default is `1000`.
 * @property extractDocId Document ID. Use this setting when `nesting_level` is set to `none`. Default is `false`.
 * @property nestingLevel Specifies either document or table mode. Default is `none`. Valid values are `one` (table mode) and `none` (document mode).
 */
public data class EndpointMongodbSettings(
    public val authMechanism: String? = null,
    public val authSource: String? = null,
    public val authType: String? = null,
    public val docsToInvestigate: String? = null,
    public val extractDocId: String? = null,
    public val nestingLevel: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.EndpointMongodbSettings):
            EndpointMongodbSettings = EndpointMongodbSettings(
            authMechanism = javaType.authMechanism().map({ args0 -> args0 }).orElse(null),
            authSource = javaType.authSource().map({ args0 -> args0 }).orElse(null),
            authType = javaType.authType().map({ args0 -> args0 }).orElse(null),
            docsToInvestigate = javaType.docsToInvestigate().map({ args0 -> args0 }).orElse(null),
            extractDocId = javaType.extractDocId().map({ args0 -> args0 }).orElse(null),
            nestingLevel = javaType.nestingLevel().map({ args0 -> args0 }).orElse(null),
        )
    }
}
