@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketFolder Custom S3 Bucket Object prefix for intermediate storage.
 * @property bucketName Custom S3 Bucket name for intermediate storage.
 * @property encryptionMode The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
 * @property serverSideEncryptionKmsKeyId ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
 * @property serviceAccessRoleArn Amazon Resource Name (ARN) of the IAM Role with permissions to read from or write to the S3 Bucket for intermediate storage.
 */
public data class EndpointRedshiftSettings(
    public val bucketFolder: String? = null,
    public val bucketName: String? = null,
    public val encryptionMode: String? = null,
    public val serverSideEncryptionKmsKeyId: String? = null,
    public val serviceAccessRoleArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.EndpointRedshiftSettings):
            EndpointRedshiftSettings = EndpointRedshiftSettings(
            bucketFolder = javaType.bucketFolder().map({ args0 -> args0 }).orElse(null),
            bucketName = javaType.bucketName().map({ args0 -> args0 }).orElse(null),
            encryptionMode = javaType.encryptionMode().map({ args0 -> args0 }).orElse(null),
            serverSideEncryptionKmsKeyId = javaType.serverSideEncryptionKmsKeyId().map({ args0 ->
                args0
            }).orElse(null),
            serviceAccessRoleArn = javaType.serviceAccessRoleArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
