@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property addColumnName Whether to add column name information to the .csv output file. Default is `false`.
 * @property bucketFolder Custom S3 Bucket Object prefix for intermediate storage.
 * @property bucketName Custom S3 Bucket name for intermediate storage.
 * @property cannedAclForObjects Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
 * @property cdcInsertsAndUpdates Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
 * @property cdcInsertsOnly Whether to write insert operations to .csv or .parquet output files. Default is `false`.
 * @property cdcMaxBatchInterval Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. Default is `60`.
 * @property cdcMinFileSize Minimum file size condition as defined in kilobytes to output a file to Amazon S3. Default is `32000`. **NOTE:** Previously, this setting was measured in megabytes but now represents kilobytes. Update configurations accordingly.
 * @property cdcPath Folder path of CDC files. For an S3 source, this setting is required if a task captures change data; otherwise, it's optional. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
 * @property compressionType Set to compress target files. Default is `NONE`. Valid values are `GZIP` and `NONE`.
 * @property csvDelimiter Delimiter used to separate columns in the source files. Default is `,`.
 * @property csvNoSupValue String to use for all columns not included in the supplemental log.
 * @property csvNullValue String to as null when writing to the target.
 * @property csvRowDelimiter Delimiter used to separate rows in the source files. Default is `\n`.
 * @property dataFormat Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`. Default is `csv`.
 * @property dataPageSize Size of one data page in bytes. Default is `1048576` (1 MiB).
 * @property datePartitionDelimiter Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. Default is `SLASH`.
 * @property datePartitionEnabled Partition S3 bucket folders based on transaction commit dates. Default is `false`.
 * @property datePartitionSequence Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. Default is `YYYYMMDD`.
 * @property dictPageSizeLimit Maximum size in bytes of an encoded dictionary page of a column. Default is `1048576` (1 MiB).
 * @property enableStatistics Whether to enable statistics for Parquet pages and row groups. Default is `true`.
 * @property encodingType Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. Default is `rle_dictionary`.
 * @property encryptionMode The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
 * @property externalTableDefinition JSON document that describes how AWS DMS should interpret the data.
 * @property glueCatalogGeneration Whether to integrate AWS Glue Data Catalog with an Amazon S3 target. See [Using AWS Glue Data Catalog with an Amazon S3 target for AWS DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.GlueCatalog) for more information. Default is `false`.
 * @property ignoreHeaderRows When this value is set to `1`, DMS ignores the first row header in a .csv file. Default is `0`.
 * @property includeOpForFullLoad Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
 * @property maxFileSize Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. Default is `1048576` (1 GB).
 * @property parquetTimestampInMillisecond Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`.
 * @property parquetVersion Version of the .parquet file format. Default is `parquet-1-0`. Valid values are `parquet-1-0` and `parquet-2-0`.
 * @property preserveTransactions Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`.
 * @property rfc4180 For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
 * @property rowGroupLength Number of rows in a row group. Default is `10000`.
 * @property serverSideEncryptionKmsKeyId ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
 * @property serviceAccessRoleArn ARN of the IAM Role with permissions to write to the OpenSearch cluster.
 * @property timestampColumnName Column to add with timestamp information to the endpoint data for an Amazon S3 target.
 * @property useCsvNoSupValue Whether to use `csv_no_sup_value` for columns not included in the supplemental log.
 * @property useTaskStartTimeForFullLoadTimestamp When set to true, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to true, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time. When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
 */
public data class EndpointS3Settings(
    public val addColumnName: Boolean? = null,
    public val bucketFolder: String? = null,
    public val bucketName: String? = null,
    public val cannedAclForObjects: String? = null,
    public val cdcInsertsAndUpdates: Boolean? = null,
    public val cdcInsertsOnly: Boolean? = null,
    public val cdcMaxBatchInterval: Int? = null,
    public val cdcMinFileSize: Int? = null,
    public val cdcPath: String? = null,
    public val compressionType: String? = null,
    public val csvDelimiter: String? = null,
    public val csvNoSupValue: String? = null,
    public val csvNullValue: String? = null,
    public val csvRowDelimiter: String? = null,
    public val dataFormat: String? = null,
    public val dataPageSize: Int? = null,
    public val datePartitionDelimiter: String? = null,
    public val datePartitionEnabled: Boolean? = null,
    public val datePartitionSequence: String? = null,
    public val dictPageSizeLimit: Int? = null,
    public val enableStatistics: Boolean? = null,
    public val encodingType: String? = null,
    public val encryptionMode: String? = null,
    public val externalTableDefinition: String? = null,
    public val glueCatalogGeneration: Boolean? = null,
    public val ignoreHeaderRows: Int? = null,
    public val includeOpForFullLoad: Boolean? = null,
    public val maxFileSize: Int? = null,
    public val parquetTimestampInMillisecond: Boolean? = null,
    public val parquetVersion: String? = null,
    public val preserveTransactions: Boolean? = null,
    public val rfc4180: Boolean? = null,
    public val rowGroupLength: Int? = null,
    public val serverSideEncryptionKmsKeyId: String? = null,
    public val serviceAccessRoleArn: String? = null,
    public val timestampColumnName: String? = null,
    public val useCsvNoSupValue: Boolean? = null,
    public val useTaskStartTimeForFullLoadTimestamp: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.EndpointS3Settings): EndpointS3Settings =
            EndpointS3Settings(
                addColumnName = javaType.addColumnName().map({ args0 -> args0 }).orElse(null),
                bucketFolder = javaType.bucketFolder().map({ args0 -> args0 }).orElse(null),
                bucketName = javaType.bucketName().map({ args0 -> args0 }).orElse(null),
                cannedAclForObjects = javaType.cannedAclForObjects().map({ args0 -> args0 }).orElse(null),
                cdcInsertsAndUpdates = javaType.cdcInsertsAndUpdates().map({ args0 -> args0 }).orElse(null),
                cdcInsertsOnly = javaType.cdcInsertsOnly().map({ args0 -> args0 }).orElse(null),
                cdcMaxBatchInterval = javaType.cdcMaxBatchInterval().map({ args0 -> args0 }).orElse(null),
                cdcMinFileSize = javaType.cdcMinFileSize().map({ args0 -> args0 }).orElse(null),
                cdcPath = javaType.cdcPath().map({ args0 -> args0 }).orElse(null),
                compressionType = javaType.compressionType().map({ args0 -> args0 }).orElse(null),
                csvDelimiter = javaType.csvDelimiter().map({ args0 -> args0 }).orElse(null),
                csvNoSupValue = javaType.csvNoSupValue().map({ args0 -> args0 }).orElse(null),
                csvNullValue = javaType.csvNullValue().map({ args0 -> args0 }).orElse(null),
                csvRowDelimiter = javaType.csvRowDelimiter().map({ args0 -> args0 }).orElse(null),
                dataFormat = javaType.dataFormat().map({ args0 -> args0 }).orElse(null),
                dataPageSize = javaType.dataPageSize().map({ args0 -> args0 }).orElse(null),
                datePartitionDelimiter = javaType.datePartitionDelimiter().map({ args0 -> args0 }).orElse(null),
                datePartitionEnabled = javaType.datePartitionEnabled().map({ args0 -> args0 }).orElse(null),
                datePartitionSequence = javaType.datePartitionSequence().map({ args0 -> args0 }).orElse(null),
                dictPageSizeLimit = javaType.dictPageSizeLimit().map({ args0 -> args0 }).orElse(null),
                enableStatistics = javaType.enableStatistics().map({ args0 -> args0 }).orElse(null),
                encodingType = javaType.encodingType().map({ args0 -> args0 }).orElse(null),
                encryptionMode = javaType.encryptionMode().map({ args0 -> args0 }).orElse(null),
                externalTableDefinition = javaType.externalTableDefinition().map({ args0 -> args0 }).orElse(null),
                glueCatalogGeneration = javaType.glueCatalogGeneration().map({ args0 -> args0 }).orElse(null),
                ignoreHeaderRows = javaType.ignoreHeaderRows().map({ args0 -> args0 }).orElse(null),
                includeOpForFullLoad = javaType.includeOpForFullLoad().map({ args0 -> args0 }).orElse(null),
                maxFileSize = javaType.maxFileSize().map({ args0 -> args0 }).orElse(null),
                parquetTimestampInMillisecond = javaType.parquetTimestampInMillisecond().map({ args0 ->
                    args0
                }).orElse(null),
                parquetVersion = javaType.parquetVersion().map({ args0 -> args0 }).orElse(null),
                preserveTransactions = javaType.preserveTransactions().map({ args0 -> args0 }).orElse(null),
                rfc4180 = javaType.rfc4180().map({ args0 -> args0 }).orElse(null),
                rowGroupLength = javaType.rowGroupLength().map({ args0 -> args0 }).orElse(null),
                serverSideEncryptionKmsKeyId = javaType.serverSideEncryptionKmsKeyId().map({ args0 ->
                    args0
                }).orElse(null),
                serviceAccessRoleArn = javaType.serviceAccessRoleArn().map({ args0 -> args0 }).orElse(null),
                timestampColumnName = javaType.timestampColumnName().map({ args0 -> args0 }).orElse(null),
                useCsvNoSupValue = javaType.useCsvNoSupValue().map({ args0 -> args0 }).orElse(null),
                useTaskStartTimeForFullLoadTimestamp = javaType.useTaskStartTimeForFullLoadTimestamp().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
