@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property broker
 * @property includeControlDetails
 * @property includeNullAndEmpty
 * @property includePartitionValue
 * @property includeTableAlterOperations
 * @property includeTransactionDetails
 * @property messageFormat
 * @property messageMaxBytes
 * @property noHexPrefix
 * @property partitionIncludeSchemaTable
 * @property saslPassword
 * @property saslUsername
 * @property securityProtocol
 * @property sslCaCertificateArn
 * @property sslClientCertificateArn
 * @property sslClientKeyArn
 * @property sslClientKeyPassword
 * @property topic
 */
public data class GetEndpointKafkaSetting(
    public val broker: String,
    public val includeControlDetails: Boolean,
    public val includeNullAndEmpty: Boolean,
    public val includePartitionValue: Boolean,
    public val includeTableAlterOperations: Boolean,
    public val includeTransactionDetails: Boolean,
    public val messageFormat: String,
    public val messageMaxBytes: Int,
    public val noHexPrefix: Boolean,
    public val partitionIncludeSchemaTable: Boolean,
    public val saslPassword: String,
    public val saslUsername: String,
    public val securityProtocol: String,
    public val sslCaCertificateArn: String,
    public val sslClientCertificateArn: String,
    public val sslClientKeyArn: String,
    public val sslClientKeyPassword: String,
    public val topic: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.GetEndpointKafkaSetting):
            GetEndpointKafkaSetting = GetEndpointKafkaSetting(
            broker = javaType.broker(),
            includeControlDetails = javaType.includeControlDetails(),
            includeNullAndEmpty = javaType.includeNullAndEmpty(),
            includePartitionValue = javaType.includePartitionValue(),
            includeTableAlterOperations = javaType.includeTableAlterOperations(),
            includeTransactionDetails = javaType.includeTransactionDetails(),
            messageFormat = javaType.messageFormat(),
            messageMaxBytes = javaType.messageMaxBytes(),
            noHexPrefix = javaType.noHexPrefix(),
            partitionIncludeSchemaTable = javaType.partitionIncludeSchemaTable(),
            saslPassword = javaType.saslPassword(),
            saslUsername = javaType.saslUsername(),
            securityProtocol = javaType.securityProtocol(),
            sslCaCertificateArn = javaType.sslCaCertificateArn(),
            sslClientCertificateArn = javaType.sslClientCertificateArn(),
            sslClientKeyArn = javaType.sslClientKeyArn(),
            sslClientKeyPassword = javaType.sslClientKeyPassword(),
            topic = javaType.topic(),
        )
    }
}
