@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getReplicationInstance.
 * @property allocatedStorage The amount of storage (in gigabytes) to be initially allocated for the replication instance.
 * @property autoMinorVersionUpgrade Indicates that minor engine upgrades will be applied automatically to the replication instance during the maintenance window.
 * @property availabilityZone The EC2 Availability Zone that the replication instance will be created in.
 * @property engineVersion The engine version number of the replication instance.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyArn The Amazon Resource Name (ARN) for the KMS key used to encrypt the connection parameters.
 * @property multiAz Specifies if the replication instance is a multi-az deployment.
 * @property networkType The type of IP address protocol used by the replication instance.
 * @property preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
 * @property publiclyAccessible Specifies the accessibility options for the replication instance. A value of true represents an instance with a public IP address. A value of false represents an instance with a private IP address.
 * @property replicationInstanceArn The Amazon Resource Name (ARN) of the replication instance.
 * @property replicationInstanceClass The compute and memory capacity of the replication instance as specified by the replication instance class. See [AWS DMS User Guide](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.Types.html) for information on instance classes.
 * @property replicationInstanceId
 * @property replicationInstancePrivateIps A list of the private IP addresses of the replication instance.
 * @property replicationInstancePublicIps A list of the public IP addresses of the replication instance.
 * @property replicationSubnetGroupId A subnet group to associate with the replication instance.
 * @property tags
 * @property vpcSecurityGroupIds A set of VPC security group IDs that are used with the replication instance.
 */
public data class GetReplicationInstanceResult(
    public val allocatedStorage: Int,
    public val autoMinorVersionUpgrade: Boolean,
    public val availabilityZone: String,
    public val engineVersion: String,
    public val id: String,
    public val kmsKeyArn: String,
    public val multiAz: Boolean,
    public val networkType: String,
    public val preferredMaintenanceWindow: String,
    public val publiclyAccessible: Boolean,
    public val replicationInstanceArn: String,
    public val replicationInstanceClass: String,
    public val replicationInstanceId: String,
    public val replicationInstancePrivateIps: List<String>,
    public val replicationInstancePublicIps: List<String>,
    public val replicationSubnetGroupId: String,
    public val tags: Map<String, String>,
    public val vpcSecurityGroupIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.GetReplicationInstanceResult):
            GetReplicationInstanceResult = GetReplicationInstanceResult(
            allocatedStorage = javaType.allocatedStorage(),
            autoMinorVersionUpgrade = javaType.autoMinorVersionUpgrade(),
            availabilityZone = javaType.availabilityZone(),
            engineVersion = javaType.engineVersion(),
            id = javaType.id(),
            kmsKeyArn = javaType.kmsKeyArn(),
            multiAz = javaType.multiAz(),
            networkType = javaType.networkType(),
            preferredMaintenanceWindow = javaType.preferredMaintenanceWindow(),
            publiclyAccessible = javaType.publiclyAccessible(),
            replicationInstanceArn = javaType.replicationInstanceArn(),
            replicationInstanceClass = javaType.replicationInstanceClass(),
            replicationInstanceId = javaType.replicationInstanceId(),
            replicationInstancePrivateIps = javaType.replicationInstancePrivateIps().map({ args0 -> args0 }),
            replicationInstancePublicIps = javaType.replicationInstancePublicIps().map({ args0 -> args0 }),
            replicationSubnetGroupId = javaType.replicationSubnetGroupId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcSecurityGroupIds = javaType.vpcSecurityGroupIds().map({ args0 -> args0 }),
        )
    }
}
