@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getReplicationSubnetGroup.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property replicationSubnetGroupArn
 * @property replicationSubnetGroupDescription Description for the subnet group.
 * @property replicationSubnetGroupId
 * @property subnetGroupStatus
 * @property subnetIds List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
 * @property tags
 * @property vpcId The ID of the VPC the subnet group is in.
 */
public data class GetReplicationSubnetGroupResult(
    public val id: String,
    public val replicationSubnetGroupArn: String,
    public val replicationSubnetGroupDescription: String,
    public val replicationSubnetGroupId: String,
    public val subnetGroupStatus: String,
    public val subnetIds: List<String>,
    public val tags: Map<String, String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.GetReplicationSubnetGroupResult):
            GetReplicationSubnetGroupResult = GetReplicationSubnetGroupResult(
            id = javaType.id(),
            replicationSubnetGroupArn = javaType.replicationSubnetGroupArn(),
            replicationSubnetGroupDescription = javaType.replicationSubnetGroupDescription(),
            replicationSubnetGroupId = javaType.replicationSubnetGroupId(),
            subnetGroupStatus = javaType.subnetGroupStatus(),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
        )
    }
}
