@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getReplicationTask.
 * @property cdcStartPosition (Conflicts with `cdc_start_time`) Indicates when you want a change data capture (CDC) operation to start. The value can be in date, checkpoint, or LSN/SCN format depending on the source engine. For more information, see [Determining a CDC native start point](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native).
 * @property cdcStartTime (Conflicts with `cdc_start_position`) The Unix timestamp integer for the start of the Change Data Capture (CDC) operation.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property migrationType The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
 * @property replicationInstanceArn The Amazon Resource Name (ARN) of the replication instance.
 * @property replicationTaskArn The Amazon Resource Name (ARN) for the replication task.
 * @property replicationTaskId
 * @property replicationTaskSettings An escaped JSON string that contains the task settings. For a complete list of task settings, see [Task Settings for AWS Database Migration Service Tasks](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html).
 * @property sourceEndpointArn The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
 * @property startReplicationTask Whether to run or stop the replication task.
 * @property status Replication Task status.
 * @property tableMappings An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
 * @property tags
 * @property targetEndpointArn The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
 */
public data class GetReplicationTaskResult(
    public val cdcStartPosition: String,
    public val cdcStartTime: String,
    public val id: String,
    public val migrationType: String,
    public val replicationInstanceArn: String,
    public val replicationTaskArn: String,
    public val replicationTaskId: String,
    public val replicationTaskSettings: String,
    public val sourceEndpointArn: String,
    public val startReplicationTask: Boolean,
    public val status: String,
    public val tableMappings: String,
    public val tags: Map<String, String>,
    public val targetEndpointArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dms.outputs.GetReplicationTaskResult):
            GetReplicationTaskResult = GetReplicationTaskResult(
            cdcStartPosition = javaType.cdcStartPosition(),
            cdcStartTime = javaType.cdcStartTime(),
            id = javaType.id(),
            migrationType = javaType.migrationType(),
            replicationInstanceArn = javaType.replicationInstanceArn(),
            replicationTaskArn = javaType.replicationTaskArn(),
            replicationTaskId = javaType.replicationTaskId(),
            replicationTaskSettings = javaType.replicationTaskSettings(),
            sourceEndpointArn = javaType.sourceEndpointArn(),
            startReplicationTask = javaType.startReplicationTask(),
            status = javaType.status(),
            tableMappings = javaType.tableMappings(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetEndpointArn = javaType.targetEndpointArn(),
        )
    }
}
