@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.aws.docdb.ClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a DocumentDB Cluster.
 * Changes to a DocumentDB Cluster can occur when you manually change a
 * parameter, such as `port`, and are reflected in the next maintenance
 * window. Because of this, this provider may report a difference in its planning
 * phase because a modification has not yet taken place. You can use the
 * `apply_immediately` flag to instruct the service to apply the change immediately
 * (see documentation below).
 * > **Note:** using `apply_immediately` can result in a brief downtime as the server reboots.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.Cluster;
 * import com.pulumi.aws.docdb.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var docdb = new Cluster("docdb", ClusterArgs.builder()
 *             .backupRetentionPeriod(5)
 *             .clusterIdentifier("my-docdb-cluster")
 *             .engine("docdb")
 *             .masterPassword("mustbeeightchars")
 *             .masterUsername("foo")
 *             .preferredBackupWindow("07:00-09:00")
 *             .skipFinalSnapshot(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DocumentDB Clusters using the `cluster_identifier`. For example:
 * ```sh
 *  $ pulumi import aws:docdb/cluster:Cluster docdb_cluster docdb-prod-cluster
 * ```
 * @property allowMajorVersionUpgrade A value that indicates whether major version upgrades are allowed. Constraints: You must allow major version upgrades when specifying a value for the EngineVersion parameter that is a different major version than the DB cluster's current version.
 * @property applyImmediately Specifies whether any cluster modifications
 * are applied immediately, or during the next maintenance window. Default is
 * `false`.
 * @property availabilityZones A list of EC2 Availability Zones that
 * instances in the DB cluster can be created in.
 * @property backupRetentionPeriod The days to retain backups for. Default `1`
 * @property clusterIdentifier The cluster identifier. If omitted, the provider will assign a random, unique identifier.
 * @property clusterIdentifierPrefix Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
 * @property clusterMembers List of DocumentDB Instances that are a part of this cluster
 * @property dbClusterParameterGroupName A cluster parameter group to associate with the cluster.
 * @property dbSubnetGroupName A DB subnet group to associate with this DB instance.
 * @property deletionProtection A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
 * @property enabledCloudwatchLogsExports List of log types to export to cloudwatch. If omitted, no logs will be exported.
 * The following log types are supported: `audit`, `profiler`.
 * @property engine The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid values: `docdb`.
 * @property engineVersion The database engine version. Updating this argument results in an outage.
 * @property finalSnapshotIdentifier The name of your final DB snapshot
 * when this DB cluster is deleted. If omitted, no final snapshot will be
 * made.
 * @property globalClusterIdentifier The global cluster identifier specified on `aws.docdb.GlobalCluster`.
 * @property kmsKeyId The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
 * @property masterPassword Password for the master DB user. Note that this may
 * show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints.
 * @property masterUsername Username for the master DB user.
 * @property port The port on which the DB accepts connections
 * @property preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
 * Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
 * @property preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
 * @property skipFinalSnapshot Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
 * @property snapshotIdentifier Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
 * @property storageEncrypted Specifies whether the DB cluster is encrypted. The default is `false`.
 * @property storageType The storage type to associate with the DB cluster. Valid values: `standard`, `iopt1`.
 * @property tags A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcSecurityGroupIds List of VPC security groups to associate
 * with the Cluster
 */
public data class ClusterArgs(
    public val allowMajorVersionUpgrade: Output<Boolean>? = null,
    public val applyImmediately: Output<Boolean>? = null,
    public val availabilityZones: Output<List<String>>? = null,
    public val backupRetentionPeriod: Output<Int>? = null,
    public val clusterIdentifier: Output<String>? = null,
    public val clusterIdentifierPrefix: Output<String>? = null,
    public val clusterMembers: Output<List<String>>? = null,
    public val dbClusterParameterGroupName: Output<String>? = null,
    public val dbSubnetGroupName: Output<String>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val enabledCloudwatchLogsExports: Output<List<String>>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val finalSnapshotIdentifier: Output<String>? = null,
    public val globalClusterIdentifier: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val masterPassword: Output<String>? = null,
    public val masterUsername: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val preferredBackupWindow: Output<String>? = null,
    public val preferredMaintenanceWindow: Output<String>? = null,
    public val skipFinalSnapshot: Output<Boolean>? = null,
    public val snapshotIdentifier: Output<String>? = null,
    public val storageEncrypted: Output<Boolean>? = null,
    public val storageType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.docdb.ClusterArgs> {
    override fun toJava(): com.pulumi.aws.docdb.ClusterArgs =
        com.pulumi.aws.docdb.ClusterArgs.builder()
            .allowMajorVersionUpgrade(allowMajorVersionUpgrade?.applyValue({ args0 -> args0 }))
            .applyImmediately(applyImmediately?.applyValue({ args0 -> args0 }))
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .backupRetentionPeriod(backupRetentionPeriod?.applyValue({ args0 -> args0 }))
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .clusterIdentifierPrefix(clusterIdentifierPrefix?.applyValue({ args0 -> args0 }))
            .clusterMembers(clusterMembers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .dbClusterParameterGroupName(dbClusterParameterGroupName?.applyValue({ args0 -> args0 }))
            .dbSubnetGroupName(dbSubnetGroupName?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .enabledCloudwatchLogsExports(
                enabledCloudwatchLogsExports?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .finalSnapshotIdentifier(finalSnapshotIdentifier?.applyValue({ args0 -> args0 }))
            .globalClusterIdentifier(globalClusterIdentifier?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .masterPassword(masterPassword?.applyValue({ args0 -> args0 }))
            .masterUsername(masterUsername?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .preferredBackupWindow(preferredBackupWindow?.applyValue({ args0 -> args0 }))
            .preferredMaintenanceWindow(preferredMaintenanceWindow?.applyValue({ args0 -> args0 }))
            .skipFinalSnapshot(skipFinalSnapshot?.applyValue({ args0 -> args0 }))
            .snapshotIdentifier(snapshotIdentifier?.applyValue({ args0 -> args0 }))
            .storageEncrypted(storageEncrypted?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcSecurityGroupIds(
                vpcSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var allowMajorVersionUpgrade: Output<Boolean>? = null

    private var applyImmediately: Output<Boolean>? = null

    private var availabilityZones: Output<List<String>>? = null

    private var backupRetentionPeriod: Output<Int>? = null

    private var clusterIdentifier: Output<String>? = null

    private var clusterIdentifierPrefix: Output<String>? = null

    private var clusterMembers: Output<List<String>>? = null

    private var dbClusterParameterGroupName: Output<String>? = null

    private var dbSubnetGroupName: Output<String>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var enabledCloudwatchLogsExports: Output<List<String>>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var finalSnapshotIdentifier: Output<String>? = null

    private var globalClusterIdentifier: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var masterPassword: Output<String>? = null

    private var masterUsername: Output<String>? = null

    private var port: Output<Int>? = null

    private var preferredBackupWindow: Output<String>? = null

    private var preferredMaintenanceWindow: Output<String>? = null

    private var skipFinalSnapshot: Output<Boolean>? = null

    private var snapshotIdentifier: Output<String>? = null

    private var storageEncrypted: Output<Boolean>? = null

    private var storageType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    /**
     * @param value A value that indicates whether major version upgrades are allowed. Constraints: You must allow major version upgrades when specifying a value for the EngineVersion parameter that is a different major version than the DB cluster's current version.
     */
    @JvmName("ccrthbdoblkpkamm")
    public suspend fun allowMajorVersionUpgrade(`value`: Output<Boolean>) {
        this.allowMajorVersionUpgrade = value
    }

    /**
     * @param value Specifies whether any cluster modifications
     * are applied immediately, or during the next maintenance window. Default is
     * `false`.
     */
    @JvmName("kyqyolbppfwmfumv")
    public suspend fun applyImmediately(`value`: Output<Boolean>) {
        this.applyImmediately = value
    }

    /**
     * @param value A list of EC2 Availability Zones that
     * instances in the DB cluster can be created in.
     */
    @JvmName("wlevstvuysrumxgh")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("wjngahswhywekkes")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values A list of EC2 Availability Zones that
     * instances in the DB cluster can be created in.
     */
    @JvmName("osilxnehiiiqgflq")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The days to retain backups for. Default `1`
     */
    @JvmName("nbekhtydimohkcsm")
    public suspend fun backupRetentionPeriod(`value`: Output<Int>) {
        this.backupRetentionPeriod = value
    }

    /**
     * @param value The cluster identifier. If omitted, the provider will assign a random, unique identifier.
     */
    @JvmName("pcqtqdyrxttxpgji")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
     */
    @JvmName("obvpcnuwgglcuydk")
    public suspend fun clusterIdentifierPrefix(`value`: Output<String>) {
        this.clusterIdentifierPrefix = value
    }

    /**
     * @param value List of DocumentDB Instances that are a part of this cluster
     */
    @JvmName("sooyccrirsmqjqdj")
    public suspend fun clusterMembers(`value`: Output<List<String>>) {
        this.clusterMembers = value
    }

    @JvmName("hqhutlmdusrdgypf")
    public suspend fun clusterMembers(vararg values: Output<String>) {
        this.clusterMembers = Output.all(values.asList())
    }

    /**
     * @param values List of DocumentDB Instances that are a part of this cluster
     */
    @JvmName("otwjhfcykkykkgwv")
    public suspend fun clusterMembers(values: List<Output<String>>) {
        this.clusterMembers = Output.all(values)
    }

    /**
     * @param value A cluster parameter group to associate with the cluster.
     */
    @JvmName("tpfkviaulpgsdusu")
    public suspend fun dbClusterParameterGroupName(`value`: Output<String>) {
        this.dbClusterParameterGroupName = value
    }

    /**
     * @param value A DB subnet group to associate with this DB instance.
     */
    @JvmName("qhgybrnientfthlm")
    public suspend fun dbSubnetGroupName(`value`: Output<String>) {
        this.dbSubnetGroupName = value
    }

    /**
     * @param value A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    @JvmName("obmgmcpoacyxpcea")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value List of log types to export to cloudwatch. If omitted, no logs will be exported.
     * The following log types are supported: `audit`, `profiler`.
     */
    @JvmName("vkosemsmfensgaqc")
    public suspend fun enabledCloudwatchLogsExports(`value`: Output<List<String>>) {
        this.enabledCloudwatchLogsExports = value
    }

    @JvmName("dyxvkecvpbfyhbxg")
    public suspend fun enabledCloudwatchLogsExports(vararg values: Output<String>) {
        this.enabledCloudwatchLogsExports = Output.all(values.asList())
    }

    /**
     * @param values List of log types to export to cloudwatch. If omitted, no logs will be exported.
     * The following log types are supported: `audit`, `profiler`.
     */
    @JvmName("dflgeurbrcqlxiuj")
    public suspend fun enabledCloudwatchLogsExports(values: List<Output<String>>) {
        this.enabledCloudwatchLogsExports = Output.all(values)
    }

    /**
     * @param value The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid values: `docdb`.
     */
    @JvmName("jlbesbkhrrluafhj")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value The database engine version. Updating this argument results in an outage.
     */
    @JvmName("nrntaahndryhuhfl")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value The name of your final DB snapshot
     * when this DB cluster is deleted. If omitted, no final snapshot will be
     * made.
     */
    @JvmName("nyyphguvxqgqgnxe")
    public suspend fun finalSnapshotIdentifier(`value`: Output<String>) {
        this.finalSnapshotIdentifier = value
    }

    /**
     * @param value The global cluster identifier specified on `aws.docdb.GlobalCluster`.
     */
    @JvmName("bcpqjyrovurejvoq")
    public suspend fun globalClusterIdentifier(`value`: Output<String>) {
        this.globalClusterIdentifier = value
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
     */
    @JvmName("teubqhamnipkirbh")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Password for the master DB user. Note that this may
     * show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints.
     */
    @JvmName("ocftdesvkhckvbct")
    public suspend fun masterPassword(`value`: Output<String>) {
        this.masterPassword = value
    }

    /**
     * @param value Username for the master DB user.
     */
    @JvmName("quhfmcauhbmpfskt")
    public suspend fun masterUsername(`value`: Output<String>) {
        this.masterUsername = value
    }

    /**
     * @param value The port on which the DB accepts connections
     */
    @JvmName("aqvdsnrqtorpevlv")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
     * Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
     */
    @JvmName("cxftisfrqssuowwm")
    public suspend fun preferredBackupWindow(`value`: Output<String>) {
        this.preferredBackupWindow = value
    }

    /**
     * @param value The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
     */
    @JvmName("rrpgxnaudmuyeffm")
    public suspend fun preferredMaintenanceWindow(`value`: Output<String>) {
        this.preferredMaintenanceWindow = value
    }

    /**
     * @param value Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
     */
    @JvmName("dwfnlnynrhtxfftc")
    public suspend fun skipFinalSnapshot(`value`: Output<Boolean>) {
        this.skipFinalSnapshot = value
    }

    /**
     * @param value Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
     */
    @JvmName("abuxmiquyspisiew")
    public suspend fun snapshotIdentifier(`value`: Output<String>) {
        this.snapshotIdentifier = value
    }

    /**
     * @param value Specifies whether the DB cluster is encrypted. The default is `false`.
     */
    @JvmName("jmqbkydigimmtujd")
    public suspend fun storageEncrypted(`value`: Output<Boolean>) {
        this.storageEncrypted = value
    }

    /**
     * @param value The storage type to associate with the DB cluster. Valid values: `standard`, `iopt1`.
     */
    @JvmName("ygdyorwlsnavuimm")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rvukrtrsfvcmgvya")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of VPC security groups to associate
     * with the Cluster
     */
    @JvmName("apjxtpskpwqwfcgt")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("oxdbbskpddcgtecn")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of VPC security groups to associate
     * with the Cluster
     */
    @JvmName("bsqydtehrgeacjxk")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value A value that indicates whether major version upgrades are allowed. Constraints: You must allow major version upgrades when specifying a value for the EngineVersion parameter that is a different major version than the DB cluster's current version.
     */
    @JvmName("rqlsnkqiwbjrauss")
    public suspend fun allowMajorVersionUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowMajorVersionUpgrade = mapped
    }

    /**
     * @param value Specifies whether any cluster modifications
     * are applied immediately, or during the next maintenance window. Default is
     * `false`.
     */
    @JvmName("xfranqkomulhgrun")
    public suspend fun applyImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyImmediately = mapped
    }

    /**
     * @param value A list of EC2 Availability Zones that
     * instances in the DB cluster can be created in.
     */
    @JvmName("cydgyqramrqftuyn")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values A list of EC2 Availability Zones that
     * instances in the DB cluster can be created in.
     */
    @JvmName("tcappwrckmtfuidk")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The days to retain backups for. Default `1`
     */
    @JvmName("knffswbllkocilrh")
    public suspend fun backupRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionPeriod = mapped
    }

    /**
     * @param value The cluster identifier. If omitted, the provider will assign a random, unique identifier.
     */
    @JvmName("xvvvuqpobwvttmux")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
     */
    @JvmName("frxadpbtieuadvja")
    public suspend fun clusterIdentifierPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifierPrefix = mapped
    }

    /**
     * @param value List of DocumentDB Instances that are a part of this cluster
     */
    @JvmName("uwfpujjiryffwgwd")
    public suspend fun clusterMembers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterMembers = mapped
    }

    /**
     * @param values List of DocumentDB Instances that are a part of this cluster
     */
    @JvmName("sbjdnlufernobllm")
    public suspend fun clusterMembers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterMembers = mapped
    }

    /**
     * @param value A cluster parameter group to associate with the cluster.
     */
    @JvmName("qjimchghoaevxajo")
    public suspend fun dbClusterParameterGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterParameterGroupName = mapped
    }

    /**
     * @param value A DB subnet group to associate with this DB instance.
     */
    @JvmName("sjhvxureftfewsgk")
    public suspend fun dbSubnetGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbSubnetGroupName = mapped
    }

    /**
     * @param value A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    @JvmName("gytfvlfurrwclpwk")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value List of log types to export to cloudwatch. If omitted, no logs will be exported.
     * The following log types are supported: `audit`, `profiler`.
     */
    @JvmName("ubkudjvbguqlxoaf")
    public suspend fun enabledCloudwatchLogsExports(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledCloudwatchLogsExports = mapped
    }

    /**
     * @param values List of log types to export to cloudwatch. If omitted, no logs will be exported.
     * The following log types are supported: `audit`, `profiler`.
     */
    @JvmName("wpngfbveigdeplry")
    public suspend fun enabledCloudwatchLogsExports(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledCloudwatchLogsExports = mapped
    }

    /**
     * @param value The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid values: `docdb`.
     */
    @JvmName("kbvdpqubvvfqchqr")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value The database engine version. Updating this argument results in an outage.
     */
    @JvmName("yhjolcxrmewvhlvm")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value The name of your final DB snapshot
     * when this DB cluster is deleted. If omitted, no final snapshot will be
     * made.
     */
    @JvmName("qfshpxbsyqktdtfs")
    public suspend fun finalSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.finalSnapshotIdentifier = mapped
    }

    /**
     * @param value The global cluster identifier specified on `aws.docdb.GlobalCluster`.
     */
    @JvmName("vigywnqldanmtvbs")
    public suspend fun globalClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalClusterIdentifier = mapped
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
     */
    @JvmName("rtfqfivwdlwahxed")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Password for the master DB user. Note that this may
     * show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints.
     */
    @JvmName("hicvhhtrovfufgyv")
    public suspend fun masterPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterPassword = mapped
    }

    /**
     * @param value Username for the master DB user.
     */
    @JvmName("wskveaynelfapeyp")
    public suspend fun masterUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterUsername = mapped
    }

    /**
     * @param value The port on which the DB accepts connections
     */
    @JvmName("whhgpbnpbuknwecm")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
     * Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
     */
    @JvmName("fmjxdqteauhqijfc")
    public suspend fun preferredBackupWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBackupWindow = mapped
    }

    /**
     * @param value The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
     */
    @JvmName("pckrtahrllcnewbb")
    public suspend fun preferredMaintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredMaintenanceWindow = mapped
    }

    /**
     * @param value Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
     */
    @JvmName("hudiukrucenqyybt")
    public suspend fun skipFinalSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipFinalSnapshot = mapped
    }

    /**
     * @param value Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
     */
    @JvmName("xcprrbjwchjuysve")
    public suspend fun snapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotIdentifier = mapped
    }

    /**
     * @param value Specifies whether the DB cluster is encrypted. The default is `false`.
     */
    @JvmName("madwaokhrhflbakp")
    public suspend fun storageEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEncrypted = mapped
    }

    /**
     * @param value The storage type to associate with the DB cluster. Valid values: `standard`, `iopt1`.
     */
    @JvmName("najhovdwmapqqdou")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yavsggeajoxehamo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lbqmaokakrrfecds")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value List of VPC security groups to associate
     * with the Cluster
     */
    @JvmName("qmjmgollcwwyhsku")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values List of VPC security groups to associate
     * with the Cluster
     */
    @JvmName("acutquqobqgayxlc")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        allowMajorVersionUpgrade = allowMajorVersionUpgrade,
        applyImmediately = applyImmediately,
        availabilityZones = availabilityZones,
        backupRetentionPeriod = backupRetentionPeriod,
        clusterIdentifier = clusterIdentifier,
        clusterIdentifierPrefix = clusterIdentifierPrefix,
        clusterMembers = clusterMembers,
        dbClusterParameterGroupName = dbClusterParameterGroupName,
        dbSubnetGroupName = dbSubnetGroupName,
        deletionProtection = deletionProtection,
        enabledCloudwatchLogsExports = enabledCloudwatchLogsExports,
        engine = engine,
        engineVersion = engineVersion,
        finalSnapshotIdentifier = finalSnapshotIdentifier,
        globalClusterIdentifier = globalClusterIdentifier,
        kmsKeyId = kmsKeyId,
        masterPassword = masterPassword,
        masterUsername = masterUsername,
        port = port,
        preferredBackupWindow = preferredBackupWindow,
        preferredMaintenanceWindow = preferredMaintenanceWindow,
        skipFinalSnapshot = skipFinalSnapshot,
        snapshotIdentifier = snapshotIdentifier,
        storageEncrypted = storageEncrypted,
        storageType = storageType,
        tags = tags,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
    )
}
