@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.aws.docdb.ClusterInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an DocumentDB Cluster Resource Instance. A Cluster Instance Resource defines
 * attributes that are specific to a single instance in a [DocumentDB Cluster][1].
 * You do not designate a primary and subsequent replicas. Instead, you simply add DocumentDB
 * Instances and DocumentDB manages the replication. You can use the [count][3]
 * meta-parameter to make multiple instances and join them all to the same DocumentDB
 * Cluster, or you may specify different Cluster Instance resources with various
 * `instance_class` sizes.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.Cluster;
 * import com.pulumi.aws.docdb.ClusterArgs;
 * import com.pulumi.aws.docdb.ClusterInstance;
 * import com.pulumi.aws.docdb.ClusterInstanceArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterIdentifier("docdb-cluster-demo")
 *             .availabilityZones(
 *                 "us-west-2a",
 *                 "us-west-2b",
 *                 "us-west-2c")
 *             .masterUsername("foo")
 *             .masterPassword("barbut8chars")
 *             .build());
 *         for (var i = 0; i < 2; i++) {
 *             new ClusterInstance("clusterInstances-" + i, ClusterInstanceArgs.builder()
 *                 .identifier(String.format("docdb-cluster-demo-%s", range.value()))
 *                 .clusterIdentifier(default_.id())
 *                 .instanceClass("db.r5.large")
 *                 .build());
 * }
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DocumentDB Cluster Instances using the `identifier`. For example:
 * ```sh
 *  $ pulumi import aws:docdb/clusterInstance:ClusterInstance prod_instance_1 aurora-cluster-instance-1
 * ```
 * @property applyImmediately Specifies whether any database modifications
 * are applied immediately, or during the next maintenance window. Default is`false`.
 * @property autoMinorVersionUpgrade This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set (see [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_DBInstance.html)). Default `true`.
 * @property availabilityZone The EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_CreateDBInstance.html) about the details.
 * @property caCertIdentifier (Optional) The identifier of the CA certificate for the DB instance.
 * @property clusterIdentifier The identifier of the `aws.docdb.Cluster` in which to launch this instance.
 * @property copyTagsToSnapshot Copy all DB instance `tags` to snapshots. Default is `false`.
 * @property enablePerformanceInsights A value that indicates whether to enable Performance Insights for the DB Instance. Default `false`. See [docs] (https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html) about the details.
 * @property engine The name of the database engine to be used for the DocumentDB instance. Defaults to `docdb`. Valid Values: `docdb`.
 * @property identifier The identifier for the DocumentDB instance, if omitted, the provider will assign a random, unique identifier.
 * @property identifierPrefix Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
 * @property instanceClass The instance class to use. For details on CPU and memory, see [Scaling for DocumentDB Instances](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-manage-performance.html#db-cluster-manage-scaling-instance).
 * DocumentDB currently supports the below instance classes.
 * Please see [AWS Documentation](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-classes.html#db-instance-class-specs) for complete details.
 * - db.r6g.large
 * - db.r6g.xlarge
 * - db.r6g.2xlarge
 * - db.r6g.4xlarge
 * - db.r6g.8xlarge
 * - db.r6g.12xlarge
 * - db.r6g.16xlarge
 * - db.r5.large
 * - db.r5.xlarge
 * - db.r5.2xlarge
 * - db.r5.4xlarge
 * - db.r5.12xlarge
 * - db.r5.24xlarge
 * - db.r4.large
 * - db.r4.xlarge
 * - db.r4.2xlarge
 * - db.r4.4xlarge
 * - db.r4.8xlarge
 * - db.r4.16xlarge
 * - db.t4g.medium
 * - db.t3.medium
 * @property performanceInsightsKmsKeyId The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key.
 * @property preferredMaintenanceWindow The window to perform maintenance in.
 * Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
 * @property promotionTier Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
 * @property tags A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterInstanceArgs(
    public val applyImmediately: Output<Boolean>? = null,
    public val autoMinorVersionUpgrade: Output<Boolean>? = null,
    public val availabilityZone: Output<String>? = null,
    public val caCertIdentifier: Output<String>? = null,
    public val clusterIdentifier: Output<String>? = null,
    public val copyTagsToSnapshot: Output<Boolean>? = null,
    public val enablePerformanceInsights: Output<Boolean>? = null,
    public val engine: Output<String>? = null,
    public val identifier: Output<String>? = null,
    public val identifierPrefix: Output<String>? = null,
    public val instanceClass: Output<String>? = null,
    public val performanceInsightsKmsKeyId: Output<String>? = null,
    public val preferredMaintenanceWindow: Output<String>? = null,
    public val promotionTier: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.docdb.ClusterInstanceArgs> {
    override fun toJava(): com.pulumi.aws.docdb.ClusterInstanceArgs =
        com.pulumi.aws.docdb.ClusterInstanceArgs.builder()
            .applyImmediately(applyImmediately?.applyValue({ args0 -> args0 }))
            .autoMinorVersionUpgrade(autoMinorVersionUpgrade?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .caCertIdentifier(caCertIdentifier?.applyValue({ args0 -> args0 }))
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .copyTagsToSnapshot(copyTagsToSnapshot?.applyValue({ args0 -> args0 }))
            .enablePerformanceInsights(enablePerformanceInsights?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .identifier(identifier?.applyValue({ args0 -> args0 }))
            .identifierPrefix(identifierPrefix?.applyValue({ args0 -> args0 }))
            .instanceClass(instanceClass?.applyValue({ args0 -> args0 }))
            .performanceInsightsKmsKeyId(performanceInsightsKmsKeyId?.applyValue({ args0 -> args0 }))
            .preferredMaintenanceWindow(preferredMaintenanceWindow?.applyValue({ args0 -> args0 }))
            .promotionTier(promotionTier?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterInstanceArgs].
 */
@PulumiTagMarker
public class ClusterInstanceArgsBuilder internal constructor() {
    private var applyImmediately: Output<Boolean>? = null

    private var autoMinorVersionUpgrade: Output<Boolean>? = null

    private var availabilityZone: Output<String>? = null

    private var caCertIdentifier: Output<String>? = null

    private var clusterIdentifier: Output<String>? = null

    private var copyTagsToSnapshot: Output<Boolean>? = null

    private var enablePerformanceInsights: Output<Boolean>? = null

    private var engine: Output<String>? = null

    private var identifier: Output<String>? = null

    private var identifierPrefix: Output<String>? = null

    private var instanceClass: Output<String>? = null

    private var performanceInsightsKmsKeyId: Output<String>? = null

    private var preferredMaintenanceWindow: Output<String>? = null

    private var promotionTier: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies whether any database modifications
     * are applied immediately, or during the next maintenance window. Default is`false`.
     */
    @JvmName("fwtrxvpycykkfwol")
    public suspend fun applyImmediately(`value`: Output<Boolean>) {
        this.applyImmediately = value
    }

    /**
     * @param value This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set (see [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_DBInstance.html)). Default `true`.
     */
    @JvmName("mdpdqlgklqbuqijo")
    public suspend fun autoMinorVersionUpgrade(`value`: Output<Boolean>) {
        this.autoMinorVersionUpgrade = value
    }

    /**
     * @param value The EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_CreateDBInstance.html) about the details.
     */
    @JvmName("jyetnbrirqpqytvg")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value (Optional) The identifier of the CA certificate for the DB instance.
     */
    @JvmName("tftiqhdjwukvkmcx")
    public suspend fun caCertIdentifier(`value`: Output<String>) {
        this.caCertIdentifier = value
    }

    /**
     * @param value The identifier of the `aws.docdb.Cluster` in which to launch this instance.
     */
    @JvmName("oaojufsmhgaxejux")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value Copy all DB instance `tags` to snapshots. Default is `false`.
     */
    @JvmName("dvxkvbyvmaotcuyd")
    public suspend fun copyTagsToSnapshot(`value`: Output<Boolean>) {
        this.copyTagsToSnapshot = value
    }

    /**
     * @param value A value that indicates whether to enable Performance Insights for the DB Instance. Default `false`. See [docs] (https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html) about the details.
     */
    @JvmName("ynwqihdacnpvuwbj")
    public suspend fun enablePerformanceInsights(`value`: Output<Boolean>) {
        this.enablePerformanceInsights = value
    }

    /**
     * @param value The name of the database engine to be used for the DocumentDB instance. Defaults to `docdb`. Valid Values: `docdb`.
     */
    @JvmName("mfxqgslhtovmykak")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value The identifier for the DocumentDB instance, if omitted, the provider will assign a random, unique identifier.
     */
    @JvmName("litgxtarqadignla")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     */
    @JvmName("amgnuaqqtorvrula")
    public suspend fun identifierPrefix(`value`: Output<String>) {
        this.identifierPrefix = value
    }

    /**
     * @param value The instance class to use. For details on CPU and memory, see [Scaling for DocumentDB Instances](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-manage-performance.html#db-cluster-manage-scaling-instance).
     * DocumentDB currently supports the below instance classes.
     * Please see [AWS Documentation](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-classes.html#db-instance-class-specs) for complete details.
     * - db.r6g.large
     * - db.r6g.xlarge
     * - db.r6g.2xlarge
     * - db.r6g.4xlarge
     * - db.r6g.8xlarge
     * - db.r6g.12xlarge
     * - db.r6g.16xlarge
     * - db.r5.large
     * - db.r5.xlarge
     * - db.r5.2xlarge
     * - db.r5.4xlarge
     * - db.r5.12xlarge
     * - db.r5.24xlarge
     * - db.r4.large
     * - db.r4.xlarge
     * - db.r4.2xlarge
     * - db.r4.4xlarge
     * - db.r4.8xlarge
     * - db.r4.16xlarge
     * - db.t4g.medium
     * - db.t3.medium
     */
    @JvmName("otobvrbsedaoqddf")
    public suspend fun instanceClass(`value`: Output<String>) {
        this.instanceClass = value
    }

    /**
     * @param value The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key.
     */
    @JvmName("frdfdfcjiuqvacsx")
    public suspend fun performanceInsightsKmsKeyId(`value`: Output<String>) {
        this.performanceInsightsKmsKeyId = value
    }

    /**
     * @param value The window to perform maintenance in.
     * Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
     */
    @JvmName("eteoidmvvjnayndg")
    public suspend fun preferredMaintenanceWindow(`value`: Output<String>) {
        this.preferredMaintenanceWindow = value
    }

    /**
     * @param value Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
     */
    @JvmName("dlorhthhjgmfgwtf")
    public suspend fun promotionTier(`value`: Output<Int>) {
        this.promotionTier = value
    }

    /**
     * @param value A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pprdnqdcfojflkyc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies whether any database modifications
     * are applied immediately, or during the next maintenance window. Default is`false`.
     */
    @JvmName("dsgfovbtduygwqdp")
    public suspend fun applyImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyImmediately = mapped
    }

    /**
     * @param value This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set (see [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_DBInstance.html)). Default `true`.
     */
    @JvmName("xykcxrbvaanbbnnh")
    public suspend fun autoMinorVersionUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoMinorVersionUpgrade = mapped
    }

    /**
     * @param value The EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_CreateDBInstance.html) about the details.
     */
    @JvmName("ctnxvurjpnbxpave")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value (Optional) The identifier of the CA certificate for the DB instance.
     */
    @JvmName("rnwvfmsuhpvsiyeu")
    public suspend fun caCertIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertIdentifier = mapped
    }

    /**
     * @param value The identifier of the `aws.docdb.Cluster` in which to launch this instance.
     */
    @JvmName("gdnqqjkjaluheslf")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value Copy all DB instance `tags` to snapshots. Default is `false`.
     */
    @JvmName("anfohfqgascadtcw")
    public suspend fun copyTagsToSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTagsToSnapshot = mapped
    }

    /**
     * @param value A value that indicates whether to enable Performance Insights for the DB Instance. Default `false`. See [docs] (https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html) about the details.
     */
    @JvmName("nqiljfvftqojdujj")
    public suspend fun enablePerformanceInsights(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePerformanceInsights = mapped
    }

    /**
     * @param value The name of the database engine to be used for the DocumentDB instance. Defaults to `docdb`. Valid Values: `docdb`.
     */
    @JvmName("wmfgxkkiwrisjjqx")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value The identifier for the DocumentDB instance, if omitted, the provider will assign a random, unique identifier.
     */
    @JvmName("khkuylwdossxqadk")
    public suspend fun identifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param value Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     */
    @JvmName("gacittrjnvqvmuvr")
    public suspend fun identifierPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifierPrefix = mapped
    }

    /**
     * @param value The instance class to use. For details on CPU and memory, see [Scaling for DocumentDB Instances](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-manage-performance.html#db-cluster-manage-scaling-instance).
     * DocumentDB currently supports the below instance classes.
     * Please see [AWS Documentation](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-classes.html#db-instance-class-specs) for complete details.
     * - db.r6g.large
     * - db.r6g.xlarge
     * - db.r6g.2xlarge
     * - db.r6g.4xlarge
     * - db.r6g.8xlarge
     * - db.r6g.12xlarge
     * - db.r6g.16xlarge
     * - db.r5.large
     * - db.r5.xlarge
     * - db.r5.2xlarge
     * - db.r5.4xlarge
     * - db.r5.12xlarge
     * - db.r5.24xlarge
     * - db.r4.large
     * - db.r4.xlarge
     * - db.r4.2xlarge
     * - db.r4.4xlarge
     * - db.r4.8xlarge
     * - db.r4.16xlarge
     * - db.t4g.medium
     * - db.t3.medium
     */
    @JvmName("laxxqvrttjfhxsvw")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceClass = mapped
    }

    /**
     * @param value The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key.
     */
    @JvmName("pshpeinafnvhcbpj")
    public suspend fun performanceInsightsKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceInsightsKmsKeyId = mapped
    }

    /**
     * @param value The window to perform maintenance in.
     * Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
     */
    @JvmName("cybnpuwuecnwocgj")
    public suspend fun preferredMaintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredMaintenanceWindow = mapped
    }

    /**
     * @param value Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
     */
    @JvmName("nhhweovhafmufmnc")
    public suspend fun promotionTier(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promotionTier = mapped
    }

    /**
     * @param value A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sjpjprqwdxxgfhcu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ayxbecrpwoihvkix")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterInstanceArgs = ClusterInstanceArgs(
        applyImmediately = applyImmediately,
        autoMinorVersionUpgrade = autoMinorVersionUpgrade,
        availabilityZone = availabilityZone,
        caCertIdentifier = caCertIdentifier,
        clusterIdentifier = clusterIdentifier,
        copyTagsToSnapshot = copyTagsToSnapshot,
        enablePerformanceInsights = enablePerformanceInsights,
        engine = engine,
        identifier = identifier,
        identifierPrefix = identifierPrefix,
        instanceClass = instanceClass,
        performanceInsightsKmsKeyId = performanceInsightsKmsKeyId,
        preferredMaintenanceWindow = preferredMaintenanceWindow,
        promotionTier = promotionTier,
        tags = tags,
    )
}
