@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.aws.docdb.kotlin.outputs.ClusterParameterGroupParameter
import com.pulumi.aws.docdb.kotlin.outputs.ClusterParameterGroupParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ClusterParameterGroup].
 */
@PulumiTagMarker
public class ClusterParameterGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterParameterGroupArgs = ClusterParameterGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterParameterGroupArgsBuilder.() -> Unit) {
        val builder = ClusterParameterGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ClusterParameterGroup {
        val builtJavaResource = com.pulumi.aws.docdb.ClusterParameterGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterParameterGroup(builtJavaResource)
    }
}

/**
 * Manages a DocumentDB Cluster Parameter Group
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.ClusterParameterGroup;
 * import com.pulumi.aws.docdb.ClusterParameterGroupArgs;
 * import com.pulumi.aws.docdb.inputs.ClusterParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterParameterGroup("example", ClusterParameterGroupArgs.builder()
 *             .description("docdb cluster parameter group")
 *             .family("docdb3.6")
 *             .parameters(ClusterParameterGroupParameterArgs.builder()
 *                 .name("tls")
 *                 .value("enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DocumentDB Cluster Parameter Groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:docdb/clusterParameterGroup:ClusterParameterGroup cluster_pg production-pg-1
 * ```
 *
 */
public class ClusterParameterGroup internal constructor(
    override val javaResource: com.pulumi.aws.docdb.ClusterParameterGroup,
) : KotlinCustomResource(javaResource, ClusterParameterGroupMapper) {
    /**
     * The ARN of the DocumentDB cluster parameter group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the DocumentDB cluster parameter group. Defaults to "Managed by Pulumi".
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The family of the DocumentDB cluster parameter group.
     */
    public val family: Output<String>
        get() = javaResource.family().applyValue({ args0 -> args0 })

    /**
     * The name of the DocumentDB parameter.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * A list of DocumentDB parameters to apply. Setting parameters to system default values may show a difference on imported resources.
     */
    public val parameters: Output<List<ClusterParameterGroupParameter>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ClusterParameterGroupMapper : ResourceMapper<ClusterParameterGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.docdb.ClusterParameterGroup::class == javaResource::class

    override fun map(javaResource: Resource): ClusterParameterGroup =
        ClusterParameterGroup(javaResource as com.pulumi.aws.docdb.ClusterParameterGroup)
}

/**
 * @see [ClusterParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterParameterGroup].
 */
public suspend fun clusterParameterGroup(
    name: String,
    block: suspend ClusterParameterGroupResourceBuilder.() -> Unit,
): ClusterParameterGroup {
    val builder = ClusterParameterGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterParameterGroup(name: String): ClusterParameterGroup {
    val builder = ClusterParameterGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
