@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.aws.docdb.ClusterParameterGroupArgs.builder
import com.pulumi.aws.docdb.kotlin.inputs.ClusterParameterGroupParameterArgs
import com.pulumi.aws.docdb.kotlin.inputs.ClusterParameterGroupParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a DocumentDB Cluster Parameter Group
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.ClusterParameterGroup;
 * import com.pulumi.aws.docdb.ClusterParameterGroupArgs;
 * import com.pulumi.aws.docdb.inputs.ClusterParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterParameterGroup("example", ClusterParameterGroupArgs.builder()
 *             .description("docdb cluster parameter group")
 *             .family("docdb3.6")
 *             .parameters(ClusterParameterGroupParameterArgs.builder()
 *                 .name("tls")
 *                 .value("enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DocumentDB Cluster Parameter Groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:docdb/clusterParameterGroup:ClusterParameterGroup cluster_pg production-pg-1
 * ```
 * @property description The description of the DocumentDB cluster parameter group. Defaults to "Managed by Pulumi".
 * @property family The family of the DocumentDB cluster parameter group.
 * @property name The name of the DocumentDB parameter.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property parameters A list of DocumentDB parameters to apply. Setting parameters to system default values may show a difference on imported resources.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterParameterGroupArgs(
    public val description: Output<String>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val parameters: Output<List<ClusterParameterGroupParameterArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.docdb.ClusterParameterGroupArgs> {
    override fun toJava(): com.pulumi.aws.docdb.ClusterParameterGroupArgs =
        com.pulumi.aws.docdb.ClusterParameterGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterParameterGroupArgs].
 */
@PulumiTagMarker
public class ClusterParameterGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var parameters: Output<List<ClusterParameterGroupParameterArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the DocumentDB cluster parameter group. Defaults to "Managed by Pulumi".
     */
    @JvmName("rfjdarexinxamuwg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The family of the DocumentDB cluster parameter group.
     */
    @JvmName("lqfgklbxjlouhfsp")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The name of the DocumentDB parameter.
     */
    @JvmName("teaebkyoskahhuiy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("moskglryxaowdwha")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value A list of DocumentDB parameters to apply. Setting parameters to system default values may show a difference on imported resources.
     */
    @JvmName("mycxdorgrbxincdg")
    public suspend fun parameters(`value`: Output<List<ClusterParameterGroupParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("pbeicbctfnwiytkx")
    public suspend fun parameters(vararg values: Output<ClusterParameterGroupParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values A list of DocumentDB parameters to apply. Setting parameters to system default values may show a difference on imported resources.
     */
    @JvmName("wkwncincgvavhcnl")
    public suspend fun parameters(values: List<Output<ClusterParameterGroupParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("umehyjmmhtunlvjf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the DocumentDB cluster parameter group. Defaults to "Managed by Pulumi".
     */
    @JvmName("ofjpyrmtuiwpqieo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The family of the DocumentDB cluster parameter group.
     */
    @JvmName("vklncpmbfalnesin")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the DocumentDB parameter.
     */
    @JvmName("wymnmofsejsesuiy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("vsppoojfudljjnoy")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value A list of DocumentDB parameters to apply. Setting parameters to system default values may show a difference on imported resources.
     */
    @JvmName("hrweqmdoidopdfbe")
    public suspend fun parameters(`value`: List<ClusterParameterGroupParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument A list of DocumentDB parameters to apply. Setting parameters to system default values may show a difference on imported resources.
     */
    @JvmName("pckwyvdsjvtekjwt")
    public suspend
    fun parameters(argument: List<suspend ClusterParameterGroupParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterParameterGroupParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A list of DocumentDB parameters to apply. Setting parameters to system default values may show a difference on imported resources.
     */
    @JvmName("gdtvtrfsrhnpasit")
    public suspend fun parameters(
        vararg
        argument: suspend ClusterParameterGroupParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ClusterParameterGroupParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A list of DocumentDB parameters to apply. Setting parameters to system default values may show a difference on imported resources.
     */
    @JvmName("hrrcivssavbupwdj")
    public suspend
    fun parameters(argument: suspend ClusterParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterParameterGroupParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values A list of DocumentDB parameters to apply. Setting parameters to system default values may show a difference on imported resources.
     */
    @JvmName("yvxivtffbxjpysbq")
    public suspend fun parameters(vararg values: ClusterParameterGroupParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("idiqtjbvvlenhhit")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qwbwjyyehdmicrle")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterParameterGroupArgs = ClusterParameterGroupArgs(
        description = description,
        family = family,
        name = name,
        namePrefix = namePrefix,
        parameters = parameters,
        tags = tags,
    )
}
