@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ClusterSnapshot].
 */
@PulumiTagMarker
public class ClusterSnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterSnapshotArgs = ClusterSnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterSnapshotArgsBuilder.() -> Unit) {
        val builder = ClusterSnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ClusterSnapshot {
        val builtJavaResource = com.pulumi.aws.docdb.ClusterSnapshot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterSnapshot(builtJavaResource)
    }
}

/**
 * Manages a DocumentDB database cluster snapshot for DocumentDB clusters.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.ClusterSnapshot;
 * import com.pulumi.aws.docdb.ClusterSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterSnapshot("example", ClusterSnapshotArgs.builder()
 *             .dbClusterIdentifier(aws_docdb_cluster.example().id())
 *             .dbClusterSnapshotIdentifier("resourcetestsnapshot1234")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_docdb_cluster_snapshot` using the cluster snapshot identifier. For example:
 * ```sh
 *  $ pulumi import aws:docdb/clusterSnapshot:ClusterSnapshot example my-cluster-snapshot
 * ```
 *
 */
public class ClusterSnapshot internal constructor(
    override val javaResource: com.pulumi.aws.docdb.ClusterSnapshot,
) : KotlinCustomResource(javaResource, ClusterSnapshotMapper) {
    /**
     * List of EC2 Availability Zones that instances in the DocumentDB cluster snapshot can be restored in.
     */
    public val availabilityZones: Output<List<String>>
        get() = javaResource.availabilityZones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The DocumentDB Cluster Identifier from which to take the snapshot.
     */
    public val dbClusterIdentifier: Output<String>
        get() = javaResource.dbClusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the DocumentDB Cluster Snapshot.
     */
    public val dbClusterSnapshotArn: Output<String>
        get() = javaResource.dbClusterSnapshotArn().applyValue({ args0 -> args0 })

    /**
     * The Identifier for the snapshot.
     */
    public val dbClusterSnapshotIdentifier: Output<String>
        get() = javaResource.dbClusterSnapshotIdentifier().applyValue({ args0 -> args0 })

    /**
     * Specifies the name of the database engine.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * Version of the database engine for this DocumentDB cluster snapshot.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * If storage_encrypted is true, the AWS KMS key identifier for the encrypted DocumentDB cluster snapshot.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Port that the DocumentDB cluster was listening on at the time of the snapshot.
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    public val snapshotType: Output<String>
        get() = javaResource.snapshotType().applyValue({ args0 -> args0 })

    public val sourceDbClusterSnapshotArn: Output<String>
        get() = javaResource.sourceDbClusterSnapshotArn().applyValue({ args0 -> args0 })

    /**
     * The status of this DocumentDB Cluster Snapshot.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the DocumentDB cluster snapshot is encrypted.
     */
    public val storageEncrypted: Output<Boolean>
        get() = javaResource.storageEncrypted().applyValue({ args0 -> args0 })

    /**
     * The VPC ID associated with the DocumentDB cluster snapshot.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object ClusterSnapshotMapper : ResourceMapper<ClusterSnapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.docdb.ClusterSnapshot::class == javaResource::class

    override fun map(javaResource: Resource): ClusterSnapshot = ClusterSnapshot(
        javaResource as
            com.pulumi.aws.docdb.ClusterSnapshot,
    )
}

/**
 * @see [ClusterSnapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterSnapshot].
 */
public suspend fun clusterSnapshot(
    name: String,
    block: suspend ClusterSnapshotResourceBuilder.() -> Unit,
): ClusterSnapshot {
    val builder = ClusterSnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterSnapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterSnapshot(name: String): ClusterSnapshot {
    val builder = ClusterSnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
