@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.aws.docdb.ClusterSnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a DocumentDB database cluster snapshot for DocumentDB clusters.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.ClusterSnapshot;
 * import com.pulumi.aws.docdb.ClusterSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterSnapshot("example", ClusterSnapshotArgs.builder()
 *             .dbClusterIdentifier(aws_docdb_cluster.example().id())
 *             .dbClusterSnapshotIdentifier("resourcetestsnapshot1234")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_docdb_cluster_snapshot` using the cluster snapshot identifier. For example:
 * ```sh
 *  $ pulumi import aws:docdb/clusterSnapshot:ClusterSnapshot example my-cluster-snapshot
 * ```
 * @property dbClusterIdentifier The DocumentDB Cluster Identifier from which to take the snapshot.
 * @property dbClusterSnapshotIdentifier The Identifier for the snapshot.
 */
public data class ClusterSnapshotArgs(
    public val dbClusterIdentifier: Output<String>? = null,
    public val dbClusterSnapshotIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.docdb.ClusterSnapshotArgs> {
    override fun toJava(): com.pulumi.aws.docdb.ClusterSnapshotArgs =
        com.pulumi.aws.docdb.ClusterSnapshotArgs.builder()
            .dbClusterIdentifier(dbClusterIdentifier?.applyValue({ args0 -> args0 }))
            .dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterSnapshotArgs].
 */
@PulumiTagMarker
public class ClusterSnapshotArgsBuilder internal constructor() {
    private var dbClusterIdentifier: Output<String>? = null

    private var dbClusterSnapshotIdentifier: Output<String>? = null

    /**
     * @param value The DocumentDB Cluster Identifier from which to take the snapshot.
     */
    @JvmName("sljqyicmuydbyads")
    public suspend fun dbClusterIdentifier(`value`: Output<String>) {
        this.dbClusterIdentifier = value
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("tsgnptjbvxwgfokj")
    public suspend fun dbClusterSnapshotIdentifier(`value`: Output<String>) {
        this.dbClusterSnapshotIdentifier = value
    }

    /**
     * @param value The DocumentDB Cluster Identifier from which to take the snapshot.
     */
    @JvmName("fwluevrddjuydpmq")
    public suspend fun dbClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterIdentifier = mapped
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("jfwbrlxlvdklvfsy")
    public suspend fun dbClusterSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterSnapshotIdentifier = mapped
    }

    internal fun build(): ClusterSnapshotArgs = ClusterSnapshotArgs(
        dbClusterIdentifier = dbClusterIdentifier,
        dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier,
    )
}
