@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [EventSubscription].
 */
@PulumiTagMarker
public class EventSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventSubscriptionArgs = EventSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventSubscriptionArgsBuilder.() -> Unit) {
        val builder = EventSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EventSubscription {
        val builtJavaResource = com.pulumi.aws.docdb.EventSubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventSubscription(builtJavaResource)
    }
}

/**
 * Provides a DocumentDB event subscription resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.Cluster;
 * import com.pulumi.aws.docdb.ClusterArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.docdb.EventSubscription;
 * import com.pulumi.aws.docdb.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCluster = new Cluster("exampleCluster", ClusterArgs.builder()
 *             .clusterIdentifier("example")
 *             .availabilityZones(
 *                 data.aws_availability_zones().available().names()[0],
 *                 data.aws_availability_zones().available().names()[1],
 *                 data.aws_availability_zones().available().names()[2])
 *             .masterUsername("foo")
 *             .masterPassword("mustbeeightcharaters")
 *             .skipFinalSnapshot(true)
 *             .build());
 *         var exampleTopic = new Topic("exampleTopic");
 *         var exampleEventSubscription = new EventSubscription("exampleEventSubscription", EventSubscriptionArgs.builder()
 *             .enabled(true)
 *             .eventCategories(
 *                 "creation",
 *                 "failure")
 *             .sourceType("db-cluster")
 *             .sourceIds(exampleCluster.id())
 *             .snsTopicArn(exampleTopic.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DocumentDB Event Subscriptions using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:docdb/eventSubscription:EventSubscription example event-sub
 * ```
 *
 */
public class EventSubscription internal constructor(
    override val javaResource: com.pulumi.aws.docdb.EventSubscription,
) : KotlinCustomResource(javaResource, EventSubscriptionMapper) {
    /**
     * The Amazon Resource Name of the DocumentDB event notification subscription
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AWS customer account associated with the DocumentDB event notification subscription
     */
    public val customerAwsId: Output<String>
        get() = javaResource.customerAwsId().applyValue({ args0 -> args0 })

    /**
     * A boolean flag to enable/disable the subscription. Defaults to true.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/documentdb/latest/developerguide/API_Event.html or run `aws docdb describe-event-categories`.
     */
    public val eventCategories: Output<List<String>>?
        get() = javaResource.eventCategories().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The name of the DocumentDB event subscription. By default generated by this provider.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the DocumentDB event subscription. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    public val snsTopicArn: Output<String>
        get() = javaResource.snsTopicArn().applyValue({ args0 -> args0 })

    /**
     * A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    public val sourceIds: Output<List<String>>?
        get() = javaResource.sourceIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The type of source that will be generating the events. Valid options are `db-instance`, `db-cluster`, `db-parameter-group`, `db-security-group`,` db-cluster-snapshot`. If not set, all sources will be subscribed to.
     */
    public val sourceType: Output<String>?
        get() = javaResource.sourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object EventSubscriptionMapper : ResourceMapper<EventSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.docdb.EventSubscription::class == javaResource::class

    override fun map(javaResource: Resource): EventSubscription = EventSubscription(
        javaResource as
            com.pulumi.aws.docdb.EventSubscription,
    )
}

/**
 * @see [EventSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventSubscription].
 */
public suspend fun eventSubscription(
    name: String,
    block: suspend EventSubscriptionResourceBuilder.() -> Unit,
): EventSubscription {
    val builder = EventSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventSubscription(name: String): EventSubscription {
    val builder = EventSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
