@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.aws.docdb.EventSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DocumentDB event subscription resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.Cluster;
 * import com.pulumi.aws.docdb.ClusterArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.docdb.EventSubscription;
 * import com.pulumi.aws.docdb.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCluster = new Cluster("exampleCluster", ClusterArgs.builder()
 *             .clusterIdentifier("example")
 *             .availabilityZones(
 *                 data.aws_availability_zones().available().names()[0],
 *                 data.aws_availability_zones().available().names()[1],
 *                 data.aws_availability_zones().available().names()[2])
 *             .masterUsername("foo")
 *             .masterPassword("mustbeeightcharaters")
 *             .skipFinalSnapshot(true)
 *             .build());
 *         var exampleTopic = new Topic("exampleTopic");
 *         var exampleEventSubscription = new EventSubscription("exampleEventSubscription", EventSubscriptionArgs.builder()
 *             .enabled(true)
 *             .eventCategories(
 *                 "creation",
 *                 "failure")
 *             .sourceType("db-cluster")
 *             .sourceIds(exampleCluster.id())
 *             .snsTopicArn(exampleTopic.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DocumentDB Event Subscriptions using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:docdb/eventSubscription:EventSubscription example event-sub
 * ```
 * @property enabled A boolean flag to enable/disable the subscription. Defaults to true.
 * @property eventCategories A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/documentdb/latest/developerguide/API_Event.html or run `aws docdb describe-event-categories`.
 * @property name The name of the DocumentDB event subscription. By default generated by this provider.
 * @property namePrefix The name of the DocumentDB event subscription. Conflicts with `name`.
 * @property snsTopicArn
 * @property sourceIds A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
 * @property sourceType The type of source that will be generating the events. Valid options are `db-instance`, `db-cluster`, `db-parameter-group`, `db-security-group`,` db-cluster-snapshot`. If not set, all sources will be subscribed to.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EventSubscriptionArgs(
    public val enabled: Output<Boolean>? = null,
    public val eventCategories: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val snsTopicArn: Output<String>? = null,
    public val sourceIds: Output<List<String>>? = null,
    public val sourceType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.docdb.EventSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.docdb.EventSubscriptionArgs =
        com.pulumi.aws.docdb.EventSubscriptionArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .eventCategories(eventCategories?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .snsTopicArn(snsTopicArn?.applyValue({ args0 -> args0 }))
            .sourceIds(sourceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventSubscriptionArgs].
 */
@PulumiTagMarker
public class EventSubscriptionArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var eventCategories: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var snsTopicArn: Output<String>? = null

    private var sourceIds: Output<List<String>>? = null

    private var sourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A boolean flag to enable/disable the subscription. Defaults to true.
     */
    @JvmName("lpkrgthmbvyvbtes")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/documentdb/latest/developerguide/API_Event.html or run `aws docdb describe-event-categories`.
     */
    @JvmName("mtsatlmngvcowhxu")
    public suspend fun eventCategories(`value`: Output<List<String>>) {
        this.eventCategories = value
    }

    @JvmName("lbcdbffgvltduqwp")
    public suspend fun eventCategories(vararg values: Output<String>) {
        this.eventCategories = Output.all(values.asList())
    }

    /**
     * @param values A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/documentdb/latest/developerguide/API_Event.html or run `aws docdb describe-event-categories`.
     */
    @JvmName("bhbrajnwqckaqvyb")
    public suspend fun eventCategories(values: List<Output<String>>) {
        this.eventCategories = Output.all(values)
    }

    /**
     * @param value The name of the DocumentDB event subscription. By default generated by this provider.
     */
    @JvmName("bmgnodtxexqeqots")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the DocumentDB event subscription. Conflicts with `name`.
     */
    @JvmName("irujhptvcbvxhagj")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value
     */
    @JvmName("timbgmljybfsmmsf")
    public suspend fun snsTopicArn(`value`: Output<String>) {
        this.snsTopicArn = value
    }

    /**
     * @param value A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    @JvmName("nlsechdjwdhkekqy")
    public suspend fun sourceIds(`value`: Output<List<String>>) {
        this.sourceIds = value
    }

    @JvmName("eiaqlkoiukbftgmn")
    public suspend fun sourceIds(vararg values: Output<String>) {
        this.sourceIds = Output.all(values.asList())
    }

    /**
     * @param values A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    @JvmName("higdotsqswvjowbf")
    public suspend fun sourceIds(values: List<Output<String>>) {
        this.sourceIds = Output.all(values)
    }

    /**
     * @param value The type of source that will be generating the events. Valid options are `db-instance`, `db-cluster`, `db-parameter-group`, `db-security-group`,` db-cluster-snapshot`. If not set, all sources will be subscribed to.
     */
    @JvmName("iwvckyhbrwoubojy")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ewaxvgcmftrgvesi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A boolean flag to enable/disable the subscription. Defaults to true.
     */
    @JvmName("rfmiwaveggnjutjw")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/documentdb/latest/developerguide/API_Event.html or run `aws docdb describe-event-categories`.
     */
    @JvmName("fguqkvlrcbxkpcje")
    public suspend fun eventCategories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param values A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/documentdb/latest/developerguide/API_Event.html or run `aws docdb describe-event-categories`.
     */
    @JvmName("pfcnrhdqvvypsjiy")
    public suspend fun eventCategories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param value The name of the DocumentDB event subscription. By default generated by this provider.
     */
    @JvmName("simkgyuahkdfxgsb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the DocumentDB event subscription. Conflicts with `name`.
     */
    @JvmName("wlftlkoyrhyiabsx")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("dyqdcemlfjfryrlh")
    public suspend fun snsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicArn = mapped
    }

    /**
     * @param value A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    @JvmName("buhfmqphtglbslni")
    public suspend fun sourceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param values A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    @JvmName("wlontmsirscuwkey")
    public suspend fun sourceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param value The type of source that will be generating the events. Valid options are `db-instance`, `db-cluster`, `db-parameter-group`, `db-security-group`,` db-cluster-snapshot`. If not set, all sources will be subscribed to.
     */
    @JvmName("cgokkrcpeskcbyvx")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ityayvmsqmakunbe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cjqqpqjvaflnovtw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EventSubscriptionArgs = EventSubscriptionArgs(
        enabled = enabled,
        eventCategories = eventCategories,
        name = name,
        namePrefix = namePrefix,
        snsTopicArn = snsTopicArn,
        sourceIds = sourceIds,
        sourceType = sourceType,
        tags = tags,
    )
}
