@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin

import com.pulumi.aws.docdb.GlobalClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an DocumentDB Global Cluster. A global cluster consists of one primary region and up to five read-only secondary regions. You issue write operations directly to the primary cluster in the primary region and Amazon DocumentDB automatically replicates the data to the secondary regions using dedicated infrastructure.
 * More information about DocumentDB Global Clusters can be found in the [DocumentDB Developer Guide](https://docs.aws.amazon.com/documentdb/latest/developerguide/global-clusters.html).
 * ## Example Usage
 * ### New DocumentDB Global Cluster
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.docdb.GlobalCluster;
 * import com.pulumi.aws.docdb.GlobalClusterArgs;
 * import com.pulumi.aws.docdb.Cluster;
 * import com.pulumi.aws.docdb.ClusterArgs;
 * import com.pulumi.aws.docdb.ClusterInstance;
 * import com.pulumi.aws.docdb.ClusterInstanceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Provider("primary", ProviderArgs.builder()
 *             .region("us-east-2")
 *             .build());
 *         var secondary = new Provider("secondary", ProviderArgs.builder()
 *             .region("us-east-1")
 *             .build());
 *         var example = new GlobalCluster("example", GlobalClusterArgs.builder()
 *             .globalClusterIdentifier("global-test")
 *             .engine("docdb")
 *             .engineVersion("4.0.0")
 *             .build());
 *         var primaryCluster = new Cluster("primaryCluster", ClusterArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .clusterIdentifier("test-primary-cluster")
 *             .masterUsername("username")
 *             .masterPassword("somepass123")
 *             .globalClusterIdentifier(example.id())
 *             .dbSubnetGroupName("default")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.primary())
 *                 .build());
 *         var primaryClusterInstance = new ClusterInstance("primaryClusterInstance", ClusterInstanceArgs.builder()
 *             .engine(example.engine())
 *             .identifier("test-primary-cluster-instance")
 *             .clusterIdentifier(primaryCluster.id())
 *             .instanceClass("db.r5.large")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.primary())
 *                 .build());
 *         var secondaryCluster = new Cluster("secondaryCluster", ClusterArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .clusterIdentifier("test-secondary-cluster")
 *             .globalClusterIdentifier(example.id())
 *             .dbSubnetGroupName("default")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.secondary())
 *                 .dependsOn(primaryCluster)
 *                 .build());
 *         var secondaryClusterInstance = new ClusterInstance("secondaryClusterInstance", ClusterInstanceArgs.builder()
 *             .engine(example.engine())
 *             .identifier("test-secondary-cluster-instance")
 *             .clusterIdentifier(secondaryCluster.id())
 *             .instanceClass("db.r5.large")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.secondary())
 *                 .dependsOn(primaryClusterInstance)
 *                 .build());
 *     }
 * }
 * ```
 * ### New Global Cluster From Existing DB Cluster
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.docdb.Cluster;
 * import com.pulumi.aws.docdb.GlobalCluster;
 * import com.pulumi.aws.docdb.GlobalClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCluster = new Cluster("exampleCluster");
 *         var exampleGlobalCluster = new GlobalCluster("exampleGlobalCluster", GlobalClusterArgs.builder()
 *             .globalClusterIdentifier("example")
 *             .sourceDbClusterIdentifier(exampleCluster.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_docdb_global_cluster` using the Global Cluster identifier. For example:
 * ```sh
 *  $ pulumi import aws:docdb/globalCluster:GlobalCluster example example
 * ```
 *  Certain resource arguments, like `source_db_cluster_identifier`, do not have an API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property databaseName Name for an automatically created database on cluster creation.
 * @property deletionProtection If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
 * @property engine Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Current Valid values: `docdb`. Defaults to `docdb`. Conflicts with `source_db_cluster_identifier`.
 * @property engineVersion Engine version of the global database. Upgrading the engine version will result in all cluster members being immediately updated and will.
 * * **NOTE:** Upgrading major versions is not supported.
 * @property globalClusterIdentifier The global cluster identifier.
 * @property sourceDbClusterIdentifier Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
 * @property storageEncrypted Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
 */
public data class GlobalClusterArgs(
    public val databaseName: Output<String>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val globalClusterIdentifier: Output<String>? = null,
    public val sourceDbClusterIdentifier: Output<String>? = null,
    public val storageEncrypted: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.docdb.GlobalClusterArgs> {
    override fun toJava(): com.pulumi.aws.docdb.GlobalClusterArgs =
        com.pulumi.aws.docdb.GlobalClusterArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .globalClusterIdentifier(globalClusterIdentifier?.applyValue({ args0 -> args0 }))
            .sourceDbClusterIdentifier(sourceDbClusterIdentifier?.applyValue({ args0 -> args0 }))
            .storageEncrypted(storageEncrypted?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GlobalClusterArgs].
 */
@PulumiTagMarker
public class GlobalClusterArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var globalClusterIdentifier: Output<String>? = null

    private var sourceDbClusterIdentifier: Output<String>? = null

    private var storageEncrypted: Output<Boolean>? = null

    /**
     * @param value Name for an automatically created database on cluster creation.
     */
    @JvmName("vqxbmytkjgvlnkqy")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
     */
    @JvmName("wpwfqpoybwqitgid")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Current Valid values: `docdb`. Defaults to `docdb`. Conflicts with `source_db_cluster_identifier`.
     */
    @JvmName("jpikcwiyrwvtulrx")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value Engine version of the global database. Upgrading the engine version will result in all cluster members being immediately updated and will.
     * * **NOTE:** Upgrading major versions is not supported.
     */
    @JvmName("lixappmnsrmhnuke")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value The global cluster identifier.
     */
    @JvmName("qwxauahhwxcsstke")
    public suspend fun globalClusterIdentifier(`value`: Output<String>) {
        this.globalClusterIdentifier = value
    }

    /**
     * @param value Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
     */
    @JvmName("dkbivkvibfwhrvit")
    public suspend fun sourceDbClusterIdentifier(`value`: Output<String>) {
        this.sourceDbClusterIdentifier = value
    }

    /**
     * @param value Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("oddrjilwegpfiqui")
    public suspend fun storageEncrypted(`value`: Output<Boolean>) {
        this.storageEncrypted = value
    }

    /**
     * @param value Name for an automatically created database on cluster creation.
     */
    @JvmName("ivdanbbmmrjkyojr")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
     */
    @JvmName("bhhprnrwesbaewyi")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Current Valid values: `docdb`. Defaults to `docdb`. Conflicts with `source_db_cluster_identifier`.
     */
    @JvmName("wcagcyvwntskkxgp")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value Engine version of the global database. Upgrading the engine version will result in all cluster members being immediately updated and will.
     * * **NOTE:** Upgrading major versions is not supported.
     */
    @JvmName("njrilrxsmspahldi")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value The global cluster identifier.
     */
    @JvmName("mlsxintpwnsjstdn")
    public suspend fun globalClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalClusterIdentifier = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
     */
    @JvmName("ringvhwjveowlqjk")
    public suspend fun sourceDbClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDbClusterIdentifier = mapped
    }

    /**
     * @param value Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("rutdmoktohufovow")
    public suspend fun storageEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEncrypted = mapped
    }

    internal fun build(): GlobalClusterArgs = GlobalClusterArgs(
        databaseName = databaseName,
        deletionProtection = deletionProtection,
        engine = engine,
        engineVersion = engineVersion,
        globalClusterIdentifier = globalClusterIdentifier,
        sourceDbClusterIdentifier = sourceDbClusterIdentifier,
        storageEncrypted = storageEncrypted,
    )
}
