@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin.inputs

import com.pulumi.aws.docdb.inputs.ClusterParameterGroupParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applyMethod Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
 * @property name The name of the DocumentDB parameter.
 * @property value The value of the DocumentDB parameter.
 */
public data class ClusterParameterGroupParameterArgs(
    public val applyMethod: Output<String>? = null,
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.docdb.inputs.ClusterParameterGroupParameterArgs> {
    override fun toJava(): com.pulumi.aws.docdb.inputs.ClusterParameterGroupParameterArgs =
        com.pulumi.aws.docdb.inputs.ClusterParameterGroupParameterArgs.builder()
            .applyMethod(applyMethod?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterParameterGroupParameterArgs].
 */
@PulumiTagMarker
public class ClusterParameterGroupParameterArgsBuilder internal constructor() {
    private var applyMethod: Output<String>? = null

    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
     */
    @JvmName("eysvoluhvhjkrivr")
    public suspend fun applyMethod(`value`: Output<String>) {
        this.applyMethod = value
    }

    /**
     * @param value The name of the DocumentDB parameter.
     */
    @JvmName("pkhtgvlwefrthskt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the DocumentDB parameter.
     */
    @JvmName("mfdfagikppstupow")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
     */
    @JvmName("toqhlgplgjcbvuoh")
    public suspend fun applyMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyMethod = mapped
    }

    /**
     * @param value The name of the DocumentDB parameter.
     */
    @JvmName("xxhmumyvyutfbhfa")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the DocumentDB parameter.
     */
    @JvmName("ngisjvmulcnysvxq")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ClusterParameterGroupParameterArgs = ClusterParameterGroupParameterArgs(
        applyMethod = applyMethod,
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
