@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin.inputs

import com.pulumi.aws.docdb.inputs.GetOrderableDbInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOrderableDbInstance.
 * @property engine DB engine. Default: `docdb`
 * @property engineVersion Version of the DB engine.
 * @property instanceClass DB instance class. Examples of classes are `db.r5.12xlarge`, `db.r5.24xlarge`, `db.r5.2xlarge`, `db.r5.4xlarge`, `db.r5.large`, `db.r5.xlarge`, and `db.t3.medium`. (Conflicts with `preferred_instance_classes`.)
 * @property licenseModel License model. Default: `na`
 * @property preferredInstanceClasses Ordered list of preferred DocumentDB DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. (Conflicts with `instance_class`.)
 * @property vpc Enable to show only VPC.
 */
public data class GetOrderableDbInstancePlainArgs(
    public val engine: String? = null,
    public val engineVersion: String? = null,
    public val instanceClass: String? = null,
    public val licenseModel: String? = null,
    public val preferredInstanceClasses: List<String>? = null,
    public val vpc: Boolean? = null,
) : ConvertibleToJava<com.pulumi.aws.docdb.inputs.GetOrderableDbInstancePlainArgs> {
    override fun toJava(): com.pulumi.aws.docdb.inputs.GetOrderableDbInstancePlainArgs =
        com.pulumi.aws.docdb.inputs.GetOrderableDbInstancePlainArgs.builder()
            .engine(engine?.let({ args0 -> args0 }))
            .engineVersion(engineVersion?.let({ args0 -> args0 }))
            .instanceClass(instanceClass?.let({ args0 -> args0 }))
            .licenseModel(licenseModel?.let({ args0 -> args0 }))
            .preferredInstanceClasses(preferredInstanceClasses?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpc(vpc?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOrderableDbInstancePlainArgs].
 */
@PulumiTagMarker
public class GetOrderableDbInstancePlainArgsBuilder internal constructor() {
    private var engine: String? = null

    private var engineVersion: String? = null

    private var instanceClass: String? = null

    private var licenseModel: String? = null

    private var preferredInstanceClasses: List<String>? = null

    private var vpc: Boolean? = null

    /**
     * @param value DB engine. Default: `docdb`
     */
    @JvmName("buesuwgibibpiddc")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value Version of the DB engine.
     */
    @JvmName("aevxdhdwifovhstd")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineVersion = mapped
    }

    /**
     * @param value DB instance class. Examples of classes are `db.r5.12xlarge`, `db.r5.24xlarge`, `db.r5.2xlarge`, `db.r5.4xlarge`, `db.r5.large`, `db.r5.xlarge`, and `db.t3.medium`. (Conflicts with `preferred_instance_classes`.)
     */
    @JvmName("webvqhofxpwloffq")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceClass = mapped
    }

    /**
     * @param value License model. Default: `na`
     */
    @JvmName("aqercbcrtmlwsagi")
    public suspend fun licenseModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.licenseModel = mapped
    }

    /**
     * @param value Ordered list of preferred DocumentDB DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. (Conflicts with `instance_class`.)
     */
    @JvmName("lkhhdjuipfktqanr")
    public suspend fun preferredInstanceClasses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredInstanceClasses = mapped
    }

    /**
     * @param values Ordered list of preferred DocumentDB DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. (Conflicts with `instance_class`.)
     */
    @JvmName("qwcsyysdnmswjmry")
    public suspend fun preferredInstanceClasses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredInstanceClasses = mapped
    }

    /**
     * @param value Enable to show only VPC.
     */
    @JvmName("fowdysxjeekdgtct")
    public suspend fun vpc(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpc = mapped
    }

    internal fun build(): GetOrderableDbInstancePlainArgs = GetOrderableDbInstancePlainArgs(
        engine = engine,
        engineVersion = engineVersion,
        instanceClass = instanceClass,
        licenseModel = licenseModel,
        preferredInstanceClasses = preferredInstanceClasses,
        vpc = vpc,
    )
}
