@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applyMethod Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
 * @property name The name of the DocumentDB parameter.
 * @property value The value of the DocumentDB parameter.
 */
public data class ClusterParameterGroupParameter(
    public val applyMethod: String? = null,
    public val name: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.docdb.outputs.ClusterParameterGroupParameter):
            ClusterParameterGroupParameter = ClusterParameterGroupParameter(
            applyMethod = javaType.applyMethod().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            `value` = javaType.`value`(),
        )
    }
}
