@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.docdb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dbClusterArn Amazon Resource Name (ARN) of member DB Cluster.
 * @property isWriter Whether the member is the primary DB Cluster.
 */
public data class GlobalClusterGlobalClusterMember(
    public val dbClusterArn: String? = null,
    public val isWriter: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.docdb.outputs.GlobalClusterGlobalClusterMember):
            GlobalClusterGlobalClusterMember = GlobalClusterGlobalClusterMember(
            dbClusterArn = javaType.dbClusterArn().map({ args0 -> args0 }).orElse(null),
            isWriter = javaType.isWriter().map({ args0 -> args0 }).orElse(null),
        )
    }
}
