@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.aws.dynamodb.ContributorInsightsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DynamoDB contributor insights resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.ContributorInsights;
 * import com.pulumi.aws.dynamodb.ContributorInsightsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ContributorInsights("test", ContributorInsightsArgs.builder()
 *             .tableName("ExampleTableName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_dynamodb_contributor_insights` using the format `name:table_name/index:index_name`, followed by the account number. For example:
 * ```sh
 *  $ pulumi import aws:dynamodb/contributorInsights:ContributorInsights test name:ExampleTableName/index:ExampleIndexName/123456789012
 * ```
 * @property indexName The global secondary index name
 * @property tableName The name of the table to enable contributor insights
 */
public data class ContributorInsightsArgs(
    public val indexName: Output<String>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.ContributorInsightsArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.ContributorInsightsArgs =
        com.pulumi.aws.dynamodb.ContributorInsightsArgs.builder()
            .indexName(indexName?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContributorInsightsArgs].
 */
@PulumiTagMarker
public class ContributorInsightsArgsBuilder internal constructor() {
    private var indexName: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The global secondary index name
     */
    @JvmName("vhnxlbcsbrhfdeha")
    public suspend fun indexName(`value`: Output<String>) {
        this.indexName = value
    }

    /**
     * @param value The name of the table to enable contributor insights
     */
    @JvmName("tlvamgcoybaikwrh")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The global secondary index name
     */
    @JvmName("glkkndedusiimfib")
    public suspend fun indexName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexName = mapped
    }

    /**
     * @param value The name of the table to enable contributor insights
     */
    @JvmName("bonregfpvfklugsd")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): ContributorInsightsArgs = ContributorInsightsArgs(
        indexName = indexName,
        tableName = tableName,
    )
}
