@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.aws.dynamodb.DynamodbFunctions.getTableItemPlain
import com.pulumi.aws.dynamodb.DynamodbFunctions.getTablePlain
import com.pulumi.aws.dynamodb.kotlin.inputs.GetTableItemPlainArgs
import com.pulumi.aws.dynamodb.kotlin.inputs.GetTableItemPlainArgsBuilder
import com.pulumi.aws.dynamodb.kotlin.inputs.GetTablePlainArgs
import com.pulumi.aws.dynamodb.kotlin.inputs.GetTablePlainArgsBuilder
import com.pulumi.aws.dynamodb.kotlin.inputs.GetTableServerSideEncryption
import com.pulumi.aws.dynamodb.kotlin.outputs.GetTableItemResult
import com.pulumi.aws.dynamodb.kotlin.outputs.GetTableResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.dynamodb.kotlin.outputs.GetTableItemResult.Companion.toKotlin as getTableItemResultToKotlin
import com.pulumi.aws.dynamodb.kotlin.outputs.GetTableResult.Companion.toKotlin as getTableResultToKotlin

public object DynamodbFunctions {
    /**
     * Provides information about a DynamoDB table.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.dynamodb.DynamodbFunctions;
     * import com.pulumi.aws.dynamodb.inputs.GetTableArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var tableName = DynamodbFunctions.getTable(GetTableArgs.builder()
     *             .name("tableName")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getTable.
     * @return A collection of values returned by getTable.
     */
    public suspend fun getTable(argument: GetTablePlainArgs): GetTableResult =
        getTableResultToKotlin(getTablePlain(argument.toJava()).await())

    /**
     * @see [getTable].
     * @param name Name of the DynamoDB table.
     * @param serverSideEncryption
     * @param tags
     * @return A collection of values returned by getTable.
     */
    public suspend fun getTable(
        name: String,
        serverSideEncryption: GetTableServerSideEncryption? = null,
        tags: Map<String, String>? = null,
    ): GetTableResult {
        val argument = GetTablePlainArgs(
            name = name,
            serverSideEncryption = serverSideEncryption,
            tags = tags,
        )
        return getTableResultToKotlin(getTablePlain(argument.toJava()).await())
    }

    /**
     * @see [getTable].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;dynamodb&#46;kotlin&#46;inputs&#46;GetTablePlainArgs].
     * @return A collection of values returned by getTable.
     */
    public suspend fun getTable(argument: suspend GetTablePlainArgsBuilder.() -> Unit):
        GetTableResult {
        val builder = GetTablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTableResultToKotlin(getTablePlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for retrieving a value from an AWS DynamoDB table.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.dynamodb.DynamodbFunctions;
     * import com.pulumi.aws.dynamodb.inputs.GetTableItemArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = DynamodbFunctions.getTableItem(GetTableItemArgs.builder()
     *             .tableName(aws_dynamodb_table.example().name())
     *             .expressionAttributeNames(Map.of("#P", "Percentile"))
     *             .projectionExpression("#P")
     *             .key("""
     * {
     * 	"hashKey": {"S": "example"}
     * }
     *             """)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getTableItem.
     * @return A collection of values returned by getTableItem.
     */
    public suspend fun getTableItem(argument: GetTableItemPlainArgs): GetTableItemResult =
        getTableItemResultToKotlin(getTableItemPlain(argument.toJava()).await())

    /**
     * @see [getTableItem].
     * @param expressionAttributeNames
     * @param key A map of attribute names to AttributeValue objects, representing the primary key of the item to retrieve.
     * For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.
     * The following arguments are optional:
     * @param projectionExpression A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.
     * If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.
     * @param tableName The name of the table containing the requested item.
     * @return A collection of values returned by getTableItem.
     */
    public suspend fun getTableItem(
        expressionAttributeNames: Map<String, String>? = null,
        key: String,
        projectionExpression: String? = null,
        tableName: String,
    ): GetTableItemResult {
        val argument = GetTableItemPlainArgs(
            expressionAttributeNames = expressionAttributeNames,
            key = key,
            projectionExpression = projectionExpression,
            tableName = tableName,
        )
        return getTableItemResultToKotlin(getTableItemPlain(argument.toJava()).await())
    }

    /**
     * @see [getTableItem].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;dynamodb&#46;kotlin&#46;inputs&#46;GetTableItemPlainArgs].
     * @return A collection of values returned by getTableItem.
     */
    public suspend fun getTableItem(argument: suspend GetTableItemPlainArgsBuilder.() -> Unit):
        GetTableItemResult {
        val builder = GetTableItemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTableItemResultToKotlin(getTableItemPlain(builtArgument.toJava()).await())
    }
}
