@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.aws.dynamodb.kotlin.outputs.GlobalTableReplica
import com.pulumi.aws.dynamodb.kotlin.outputs.GlobalTableReplica.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [GlobalTable].
 */
@PulumiTagMarker
public class GlobalTableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GlobalTableArgs = GlobalTableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GlobalTableArgsBuilder.() -> Unit) {
        val builder = GlobalTableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GlobalTable {
        val builtJavaResource = com.pulumi.aws.dynamodb.GlobalTable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GlobalTable(builtJavaResource)
    }
}

/**
 * Manages [DynamoDB Global Tables V1 (version 2017&#46;11&#46;29)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html). These are layered on top of existing DynamoDB Tables.
 * > **NOTE:** To instead manage [DynamoDB Global Tables V2 (version 2019&#46;11&#46;21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html), use the `aws.dynamodb.Table` resource `replica` configuration block.
 * > Note: There are many restrictions before you can properly create DynamoDB Global Tables in multiple regions. See the [AWS DynamoDB Global Table Requirements](http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables_reqs_bestpractices.html) for more information.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.dynamodb.GlobalTable;
 * import com.pulumi.aws.dynamodb.GlobalTableArgs;
 * import com.pulumi.aws.dynamodb.inputs.GlobalTableReplicaArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var us_east_1 = new Provider("us-east-1", ProviderArgs.builder()
 *             .region("us-east-1")
 *             .build());
 *         var us_west_2 = new Provider("us-west-2", ProviderArgs.builder()
 *             .region("us-west-2")
 *             .build());
 *         var us_east_1Table = new Table("us-east-1Table", TableArgs.builder()
 *             .hashKey("myAttribute")
 *             .streamEnabled(true)
 *             .streamViewType("NEW_AND_OLD_IMAGES")
 *             .readCapacity(1)
 *             .writeCapacity(1)
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("myAttribute")
 *                 .type("S")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.us-east-1())
 *                 .build());
 *         var us_west_2Table = new Table("us-west-2Table", TableArgs.builder()
 *             .hashKey("myAttribute")
 *             .streamEnabled(true)
 *             .streamViewType("NEW_AND_OLD_IMAGES")
 *             .readCapacity(1)
 *             .writeCapacity(1)
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("myAttribute")
 *                 .type("S")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.us-west-2())
 *                 .build());
 *         var myTable = new GlobalTable("myTable", GlobalTableArgs.builder()
 *             .replicas(
 *                 GlobalTableReplicaArgs.builder()
 *                     .regionName("us-east-1")
 *                     .build(),
 *                 GlobalTableReplicaArgs.builder()
 *                     .regionName("us-west-2")
 *                     .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.us-east-1())
 *                 .dependsOn(
 *                     us_east_1Table,
 *                     us_west_2Table)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DynamoDB Global Tables using the global table name. For example:
 * ```sh
 *  $ pulumi import aws:dynamodb/globalTable:GlobalTable MyTable MyTable
 * ```
 *
 */
public class GlobalTable internal constructor(
    override val javaResource: com.pulumi.aws.dynamodb.GlobalTable,
) : KotlinCustomResource(javaResource, GlobalTableMapper) {
    /**
     * The ARN of the DynamoDB Global Table
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the global table. Must match underlying DynamoDB Table names in all regions.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    public val replicas: Output<List<GlobalTableReplica>>
        get() = javaResource.replicas().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object GlobalTableMapper : ResourceMapper<GlobalTable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dynamodb.GlobalTable::class == javaResource::class

    override fun map(javaResource: Resource): GlobalTable = GlobalTable(
        javaResource as
            com.pulumi.aws.dynamodb.GlobalTable,
    )
}

/**
 * @see [GlobalTable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GlobalTable].
 */
public suspend fun globalTable(name: String, block: suspend GlobalTableResourceBuilder.() -> Unit):
    GlobalTable {
    val builder = GlobalTableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GlobalTable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun globalTable(name: String): GlobalTable {
    val builder = GlobalTableResourceBuilder()
    builder.name(name)
    return builder.build()
}
