@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.aws.dynamodb.GlobalTableArgs.builder
import com.pulumi.aws.dynamodb.kotlin.inputs.GlobalTableReplicaArgs
import com.pulumi.aws.dynamodb.kotlin.inputs.GlobalTableReplicaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages [DynamoDB Global Tables V1 (version 2017&#46;11&#46;29)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html). These are layered on top of existing DynamoDB Tables.
 * > **NOTE:** To instead manage [DynamoDB Global Tables V2 (version 2019&#46;11&#46;21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html), use the `aws.dynamodb.Table` resource `replica` configuration block.
 * > Note: There are many restrictions before you can properly create DynamoDB Global Tables in multiple regions. See the [AWS DynamoDB Global Table Requirements](http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables_reqs_bestpractices.html) for more information.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.dynamodb.GlobalTable;
 * import com.pulumi.aws.dynamodb.GlobalTableArgs;
 * import com.pulumi.aws.dynamodb.inputs.GlobalTableReplicaArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var us_east_1 = new Provider("us-east-1", ProviderArgs.builder()
 *             .region("us-east-1")
 *             .build());
 *         var us_west_2 = new Provider("us-west-2", ProviderArgs.builder()
 *             .region("us-west-2")
 *             .build());
 *         var us_east_1Table = new Table("us-east-1Table", TableArgs.builder()
 *             .hashKey("myAttribute")
 *             .streamEnabled(true)
 *             .streamViewType("NEW_AND_OLD_IMAGES")
 *             .readCapacity(1)
 *             .writeCapacity(1)
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("myAttribute")
 *                 .type("S")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.us-east-1())
 *                 .build());
 *         var us_west_2Table = new Table("us-west-2Table", TableArgs.builder()
 *             .hashKey("myAttribute")
 *             .streamEnabled(true)
 *             .streamViewType("NEW_AND_OLD_IMAGES")
 *             .readCapacity(1)
 *             .writeCapacity(1)
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("myAttribute")
 *                 .type("S")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.us-west-2())
 *                 .build());
 *         var myTable = new GlobalTable("myTable", GlobalTableArgs.builder()
 *             .replicas(
 *                 GlobalTableReplicaArgs.builder()
 *                     .regionName("us-east-1")
 *                     .build(),
 *                 GlobalTableReplicaArgs.builder()
 *                     .regionName("us-west-2")
 *                     .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.us-east-1())
 *                 .dependsOn(
 *                     us_east_1Table,
 *                     us_west_2Table)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DynamoDB Global Tables using the global table name. For example:
 * ```sh
 *  $ pulumi import aws:dynamodb/globalTable:GlobalTable MyTable MyTable
 * ```
 * @property name The name of the global table. Must match underlying DynamoDB Table names in all regions.
 * @property replicas Underlying DynamoDB Table. At least 1 replica must be defined. See below.
 */
public data class GlobalTableArgs(
    public val name: Output<String>? = null,
    public val replicas: Output<List<GlobalTableReplicaArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.GlobalTableArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.GlobalTableArgs =
        com.pulumi.aws.dynamodb.GlobalTableArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .replicas(
                replicas?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GlobalTableArgs].
 */
@PulumiTagMarker
public class GlobalTableArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var replicas: Output<List<GlobalTableReplicaArgs>>? = null

    /**
     * @param value The name of the global table. Must match underlying DynamoDB Table names in all regions.
     */
    @JvmName("gvclutgkowalriji")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("sstccxmnbrfsejnu")
    public suspend fun replicas(`value`: Output<List<GlobalTableReplicaArgs>>) {
        this.replicas = value
    }

    @JvmName("mjvhkkbkponfenly")
    public suspend fun replicas(vararg values: Output<GlobalTableReplicaArgs>) {
        this.replicas = Output.all(values.asList())
    }

    /**
     * @param values Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("mnewphugqjxvqmic")
    public suspend fun replicas(values: List<Output<GlobalTableReplicaArgs>>) {
        this.replicas = Output.all(values)
    }

    /**
     * @param value The name of the global table. Must match underlying DynamoDB Table names in all regions.
     */
    @JvmName("xgirbyiusletvabq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("wvlpigtvfrhyampf")
    public suspend fun replicas(`value`: List<GlobalTableReplicaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    /**
     * @param argument Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("knokrimjqylixsjd")
    public suspend fun replicas(argument: List<suspend GlobalTableReplicaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GlobalTableReplicaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.replicas = mapped
    }

    /**
     * @param argument Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("vqoqkprlenuldttb")
    public suspend fun replicas(vararg argument: suspend GlobalTableReplicaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GlobalTableReplicaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.replicas = mapped
    }

    /**
     * @param argument Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("akaqcjopitmtwoij")
    public suspend fun replicas(argument: suspend GlobalTableReplicaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GlobalTableReplicaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.replicas = mapped
    }

    /**
     * @param values Underlying DynamoDB Table. At least 1 replica must be defined. See below.
     */
    @JvmName("oryhmqawdjbywbyy")
    public suspend fun replicas(vararg values: GlobalTableReplicaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    internal fun build(): GlobalTableArgs = GlobalTableArgs(
        name = name,
        replicas = replicas,
    )
}
