@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [KinesisStreamingDestination].
 */
@PulumiTagMarker
public class KinesisStreamingDestinationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KinesisStreamingDestinationArgs = KinesisStreamingDestinationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KinesisStreamingDestinationArgsBuilder.() -> Unit) {
        val builder = KinesisStreamingDestinationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KinesisStreamingDestination {
        val builtJavaResource =
            com.pulumi.aws.dynamodb.KinesisStreamingDestination(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return KinesisStreamingDestination(builtJavaResource)
    }
}

/**
 * Enables a [Kinesis streaming destination](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/kds.html) for data replication of a DynamoDB table.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.dynamodb.KinesisStreamingDestination;
 * import com.pulumi.aws.dynamodb.KinesisStreamingDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleTable = new Table("exampleTable", TableArgs.builder()
 *             .hashKey("id")
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("id")
 *                 .type("S")
 *                 .build())
 *             .build());
 *         var exampleStream = new Stream("exampleStream", StreamArgs.builder()
 *             .shardCount(1)
 *             .build());
 *         var exampleKinesisStreamingDestination = new KinesisStreamingDestination("exampleKinesisStreamingDestination", KinesisStreamingDestinationArgs.builder()
 *             .streamArn(exampleStream.arn())
 *             .tableName(exampleTable.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DynamoDB Kinesis Streaming Destinations using the `table_name` and `stream_arn` separated by `,`. For example:
 * ```sh
 *  $ pulumi import aws:dynamodb/kinesisStreamingDestination:KinesisStreamingDestination example example,arn:aws:kinesis:us-east-1:111122223333:exampleStreamName
 * ```
 *
 */
public class KinesisStreamingDestination internal constructor(
    override val javaResource: com.pulumi.aws.dynamodb.KinesisStreamingDestination,
) : KotlinCustomResource(javaResource, KinesisStreamingDestinationMapper) {
    /**
     * The ARN for a Kinesis data stream. This must exist in the same account and region as the DynamoDB table.
     */
    public val streamArn: Output<String>
        get() = javaResource.streamArn().applyValue({ args0 -> args0 })

    /**
     * The name of the DynamoDB table. There
     * can only be one Kinesis streaming destination for a given DynamoDB table.
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })
}

public object KinesisStreamingDestinationMapper : ResourceMapper<KinesisStreamingDestination> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dynamodb.KinesisStreamingDestination::class == javaResource::class

    override fun map(javaResource: Resource): KinesisStreamingDestination =
        KinesisStreamingDestination(
            javaResource as
                com.pulumi.aws.dynamodb.KinesisStreamingDestination,
        )
}

/**
 * @see [KinesisStreamingDestination].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KinesisStreamingDestination].
 */
public suspend fun kinesisStreamingDestination(
    name: String,
    block: suspend KinesisStreamingDestinationResourceBuilder.() -> Unit,
):
    KinesisStreamingDestination {
    val builder = KinesisStreamingDestinationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KinesisStreamingDestination].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kinesisStreamingDestination(name: String): KinesisStreamingDestination {
    val builder = KinesisStreamingDestinationResourceBuilder()
    builder.name(name)
    return builder.build()
}
