@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.aws.dynamodb.KinesisStreamingDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Enables a [Kinesis streaming destination](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/kds.html) for data replication of a DynamoDB table.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.dynamodb.KinesisStreamingDestination;
 * import com.pulumi.aws.dynamodb.KinesisStreamingDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleTable = new Table("exampleTable", TableArgs.builder()
 *             .hashKey("id")
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("id")
 *                 .type("S")
 *                 .build())
 *             .build());
 *         var exampleStream = new Stream("exampleStream", StreamArgs.builder()
 *             .shardCount(1)
 *             .build());
 *         var exampleKinesisStreamingDestination = new KinesisStreamingDestination("exampleKinesisStreamingDestination", KinesisStreamingDestinationArgs.builder()
 *             .streamArn(exampleStream.arn())
 *             .tableName(exampleTable.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DynamoDB Kinesis Streaming Destinations using the `table_name` and `stream_arn` separated by `,`. For example:
 * ```sh
 *  $ pulumi import aws:dynamodb/kinesisStreamingDestination:KinesisStreamingDestination example example,arn:aws:kinesis:us-east-1:111122223333:exampleStreamName
 * ```
 * @property streamArn The ARN for a Kinesis data stream. This must exist in the same account and region as the DynamoDB table.
 * @property tableName The name of the DynamoDB table. There
 * can only be one Kinesis streaming destination for a given DynamoDB table.
 */
public data class KinesisStreamingDestinationArgs(
    public val streamArn: Output<String>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.KinesisStreamingDestinationArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.KinesisStreamingDestinationArgs =
        com.pulumi.aws.dynamodb.KinesisStreamingDestinationArgs.builder()
            .streamArn(streamArn?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KinesisStreamingDestinationArgs].
 */
@PulumiTagMarker
public class KinesisStreamingDestinationArgsBuilder internal constructor() {
    private var streamArn: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The ARN for a Kinesis data stream. This must exist in the same account and region as the DynamoDB table.
     */
    @JvmName("uvbvpqwgvrtiuqxd")
    public suspend fun streamArn(`value`: Output<String>) {
        this.streamArn = value
    }

    /**
     * @param value The name of the DynamoDB table. There
     * can only be one Kinesis streaming destination for a given DynamoDB table.
     */
    @JvmName("uklrjvutdqdniaoj")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The ARN for a Kinesis data stream. This must exist in the same account and region as the DynamoDB table.
     */
    @JvmName("psekwrvsxgmoagaj")
    public suspend fun streamArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamArn = mapped
    }

    /**
     * @param value The name of the DynamoDB table. There
     * can only be one Kinesis streaming destination for a given DynamoDB table.
     */
    @JvmName("aokdnnblkrcpobdt")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): KinesisStreamingDestinationArgs = KinesisStreamingDestinationArgs(
        streamArn = streamArn,
        tableName = tableName,
    )
}
