@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.aws.dynamodb.kotlin.outputs.TableAttribute
import com.pulumi.aws.dynamodb.kotlin.outputs.TableGlobalSecondaryIndex
import com.pulumi.aws.dynamodb.kotlin.outputs.TableImportTable
import com.pulumi.aws.dynamodb.kotlin.outputs.TableLocalSecondaryIndex
import com.pulumi.aws.dynamodb.kotlin.outputs.TablePointInTimeRecovery
import com.pulumi.aws.dynamodb.kotlin.outputs.TableReplica
import com.pulumi.aws.dynamodb.kotlin.outputs.TableServerSideEncryption
import com.pulumi.aws.dynamodb.kotlin.outputs.TableTtl
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.dynamodb.kotlin.outputs.TableAttribute.Companion.toKotlin as tableAttributeToKotlin
import com.pulumi.aws.dynamodb.kotlin.outputs.TableGlobalSecondaryIndex.Companion.toKotlin as tableGlobalSecondaryIndexToKotlin
import com.pulumi.aws.dynamodb.kotlin.outputs.TableImportTable.Companion.toKotlin as tableImportTableToKotlin
import com.pulumi.aws.dynamodb.kotlin.outputs.TableLocalSecondaryIndex.Companion.toKotlin as tableLocalSecondaryIndexToKotlin
import com.pulumi.aws.dynamodb.kotlin.outputs.TablePointInTimeRecovery.Companion.toKotlin as tablePointInTimeRecoveryToKotlin
import com.pulumi.aws.dynamodb.kotlin.outputs.TableReplica.Companion.toKotlin as tableReplicaToKotlin
import com.pulumi.aws.dynamodb.kotlin.outputs.TableServerSideEncryption.Companion.toKotlin as tableServerSideEncryptionToKotlin
import com.pulumi.aws.dynamodb.kotlin.outputs.TableTtl.Companion.toKotlin as tableTtlToKotlin

/**
 * Builder for [Table].
 */
@PulumiTagMarker
public class TableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TableArgs = TableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TableArgsBuilder.() -> Unit) {
        val builder = TableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Table {
        val builtJavaResource = com.pulumi.aws.dynamodb.Table(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Table(builtJavaResource)
    }
}

/**
 * Provides a DynamoDB table resource.
 * > **Note:** It is recommended to use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) for `read_capacity` and/or `write_capacity` if there's `autoscaling policy` attached to the table.
 * > **Note:** When using aws.dynamodb.TableReplica with this resource, use `lifecycle` `ignore_changes` for `replica`, _e.g._, `lifecycle { ignore_changes = [replica] }`.
 * ## DynamoDB Table attributes
 * Only define attributes on the table object that are going to be used as:
 * * Table hash key or range key
 * * LSI or GSI hash key or range key
 * The DynamoDB API expects attribute structure (name and type) to be passed along when creating or updating GSI/LSIs or creating the initial table. In these cases it expects the Hash / Range keys to be provided. Because these get re-used in numerous places (i.e the table's range key could be a part of one or more GSIs), they are stored on the table object to prevent duplication and increase consistency. If you add attributes here that are not used in these scenarios it can cause an infinite loop in planning.
 * ## Example Usage
 * ### Basic Example
 * The following dynamodb table description models the table and GSI shown in the [AWS SDK example documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.html)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableGlobalSecondaryIndexArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableTtlArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var basic_dynamodb_table = new Table("basic-dynamodb-table", TableArgs.builder()
 *             .attributes(
 *                 TableAttributeArgs.builder()
 *                     .name("UserId")
 *                     .type("S")
 *                     .build(),
 *                 TableAttributeArgs.builder()
 *                     .name("GameTitle")
 *                     .type("S")
 *                     .build(),
 *                 TableAttributeArgs.builder()
 *                     .name("TopScore")
 *                     .type("N")
 *                     .build())
 *             .billingMode("PROVISIONED")
 *             .globalSecondaryIndexes(TableGlobalSecondaryIndexArgs.builder()
 *                 .hashKey("GameTitle")
 *                 .name("GameTitleIndex")
 *                 .nonKeyAttributes("UserId")
 *                 .projectionType("INCLUDE")
 *                 .rangeKey("TopScore")
 *                 .readCapacity(10)
 *                 .writeCapacity(10)
 *                 .build())
 *             .hashKey("UserId")
 *             .rangeKey("GameTitle")
 *             .readCapacity(20)
 *             .tags(Map.ofEntries(
 *                 Map.entry("Environment", "production"),
 *                 Map.entry("Name", "dynamodb-table-1")
 *             ))
 *             .ttl(TableTtlArgs.builder()
 *                 .attributeName("TimeToExist")
 *                 .enabled(false)
 *                 .build())
 *             .writeCapacity(20)
 *             .build());
 *     }
 * }
 * ```
 * ### Global Tables
 * This resource implements support for [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html) via `replica` configuration blocks. For working with [DynamoDB Global Tables V1 (version 2017.11.29)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html), see the `aws.dynamodb.GlobalTable` resource.
 * > **Note:** aws.dynamodb.TableReplica is an alternate way of configuring Global Tables. Do not use `replica` configuration blocks of `aws.dynamodb.Table` together with aws_dynamodb_table_replica.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableReplicaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Table("example", TableArgs.builder()
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("TestTableHashKey")
 *                 .type("S")
 *                 .build())
 *             .billingMode("PAY_PER_REQUEST")
 *             .hashKey("TestTableHashKey")
 *             .replicas(
 *                 TableReplicaArgs.builder()
 *                     .regionName("us-east-2")
 *                     .build(),
 *                 TableReplicaArgs.builder()
 *                     .regionName("us-west-2")
 *                     .build())
 *             .streamEnabled(true)
 *             .streamViewType("NEW_AND_OLD_IMAGES")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DynamoDB tables using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:dynamodb/table:Table basic-dynamodb-table GameScores
 * ```
 *
 */
public class Table internal constructor(
    override val javaResource: com.pulumi.aws.dynamodb.Table,
) : KotlinCustomResource(javaResource, TableMapper) {
    /**
     * ARN of the table
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Set of nested attribute definitions. Only required for `hash_key` and `range_key` attributes. See below.
     */
    public val attributes: Output<List<TableAttribute>>
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    tableAttributeToKotlin(args0)
                })
            })
        })

    /**
     * Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
     */
    public val billingMode: Output<String>?
        get() = javaResource.billingMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables deletion protection for table. Defaults to `false`.
     */
    public val deletionProtectionEnabled: Output<Boolean>?
        get() = javaResource.deletionProtectionEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc. See below.
     */
    public val globalSecondaryIndexes: Output<List<TableGlobalSecondaryIndex>>?
        get() = javaResource.globalSecondaryIndexes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        tableGlobalSecondaryIndexToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Attribute to use as the hash (partition) key. Must also be defined as an `attribute`. See below.
     */
    public val hashKey: Output<String>
        get() = javaResource.hashKey().applyValue({ args0 -> args0 })

    /**
     * Import Amazon S3 data into a new table. See below.
     */
    public val importTable: Output<TableImportTable>?
        get() = javaResource.importTable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    tableImportTableToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Describe an LSI on the table; these can only be allocated _at creation_ so you cannot change this definition after you have created the resource. See below.
     */
    public val localSecondaryIndexes: Output<List<TableLocalSecondaryIndex>>?
        get() = javaResource.localSecondaryIndexes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        tableLocalSecondaryIndexToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Unique within a region name of the table.
     * Optional arguments:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Enable point-in-time recovery options. See below.
     */
    public val pointInTimeRecovery: Output<TablePointInTimeRecovery>
        get() = javaResource.pointInTimeRecovery().applyValue({ args0 ->
            args0.let({ args0 ->
                tablePointInTimeRecoveryToKotlin(args0)
            })
        })

    /**
     * Attribute to use as the range (sort) key. Must also be defined as an `attribute`, see below.
     */
    public val rangeKey: Output<String>?
        get() = javaResource.rangeKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
     */
    public val readCapacity: Output<Int>
        get() = javaResource.readCapacity().applyValue({ args0 -> args0 })

    /**
     * Configuration block(s) with [DynamoDB Global Tables V2 (version 2019&#46;11&#46;21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html) replication configurations. See below.
     */
    public val replicas: Output<List<TableReplica>>?
        get() = javaResource.replicas().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> tableReplicaToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Time of the point-in-time recovery point to restore.
     */
    public val restoreDateTime: Output<String>?
        get() = javaResource.restoreDateTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the table to restore. Must match the name of an existing table.
     */
    public val restoreSourceName: Output<String>?
        get() = javaResource.restoreSourceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If set, restores table to the most recent point-in-time recovery point.
     */
    public val restoreToLatestTime: Output<Boolean>?
        get() = javaResource.restoreToLatestTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS-owned Customer Master Key if this argument isn't specified. See below.
     */
    public val serverSideEncryption: Output<TableServerSideEncryption>
        get() = javaResource.serverSideEncryption().applyValue({ args0 ->
            args0.let({ args0 ->
                tableServerSideEncryptionToKotlin(args0)
            })
        })

    /**
     * ARN of the Table Stream. Only available when `stream_enabled = true`
     */
    public val streamArn: Output<String>
        get() = javaResource.streamArn().applyValue({ args0 -> args0 })

    /**
     * Whether Streams are enabled.
     */
    public val streamEnabled: Output<Boolean>?
        get() = javaResource.streamEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
     */
    public val streamLabel: Output<String>
        get() = javaResource.streamLabel().applyValue({ args0 -> args0 })

    /**
     * When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
     */
    public val streamViewType: Output<String>
        get() = javaResource.streamViewType().applyValue({ args0 -> args0 })

    /**
     * Storage class of the table.
     * Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`.
     * Default value is `STANDARD`.
     */
    public val tableClass: Output<String>?
        get() = javaResource.tableClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block for TTL. See below.
     */
    public val ttl: Output<TableTtl>
        get() = javaResource.ttl().applyValue({ args0 -> args0.let({ args0 -> tableTtlToKotlin(args0) }) })

    /**
     * Number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
     */
    public val writeCapacity: Output<Int>
        get() = javaResource.writeCapacity().applyValue({ args0 -> args0 })
}

public object TableMapper : ResourceMapper<Table> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dynamodb.Table::class == javaResource::class

    override fun map(javaResource: Resource): Table = Table(
        javaResource as
            com.pulumi.aws.dynamodb.Table,
    )
}

/**
 * @see [Table].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Table].
 */
public suspend fun table(name: String, block: suspend TableResourceBuilder.() -> Unit): Table {
    val builder = TableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Table].
 * @param name The _unique_ name of the resulting resource.
 */
public fun table(name: String): Table {
    val builder = TableResourceBuilder()
    builder.name(name)
    return builder.build()
}
