@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TableItem].
 */
@PulumiTagMarker
public class TableItemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TableItemArgs = TableItemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TableItemArgsBuilder.() -> Unit) {
        val builder = TableItemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TableItem {
        val builtJavaResource = com.pulumi.aws.dynamodb.TableItem(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TableItem(builtJavaResource)
    }
}

/**
 * Provides a DynamoDB table item resource
 * > **Note:** This resource is not meant to be used for managing large amounts of data in your table, it is not designed to scale.
 *   You should perform **regular backups** of all data in the table, see [AWS docs for more](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/BackupRestore.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.dynamodb.TableItem;
 * import com.pulumi.aws.dynamodb.TableItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleTable = new Table("exampleTable", TableArgs.builder()
 *             .readCapacity(10)
 *             .writeCapacity(10)
 *             .hashKey("exampleHashKey")
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("exampleHashKey")
 *                 .type("S")
 *                 .build())
 *             .build());
 *         var exampleTableItem = new TableItem("exampleTableItem", TableItemArgs.builder()
 *             .tableName(exampleTable.name())
 *             .hashKey(exampleTable.hashKey())
 *             .item("""
 * {
 *   "exampleHashKey": {"S": "something"},
 *   "one": {"N": "11111"},
 *   "two": {"N": "22222"},
 *   "three": {"N": "33333"},
 *   "four": {"N": "44444"}
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * You cannot import DynamoDB table items.
 */
public class TableItem internal constructor(
    override val javaResource: com.pulumi.aws.dynamodb.TableItem,
) : KotlinCustomResource(javaResource, TableItemMapper) {
    /**
     * Hash key to use for lookups and identification of the item
     */
    public val hashKey: Output<String>
        get() = javaResource.hashKey().applyValue({ args0 -> args0 })

    /**
     * JSON representation of a map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.
     */
    public val item: Output<String>
        get() = javaResource.item().applyValue({ args0 -> args0 })

    /**
     * Range key to use for lookups and identification of the item. Required if there is range key defined in the table.
     */
    public val rangeKey: Output<String>?
        get() = javaResource.rangeKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the table to contain the item.
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })
}

public object TableItemMapper : ResourceMapper<TableItem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dynamodb.TableItem::class == javaResource::class

    override fun map(javaResource: Resource): TableItem = TableItem(
        javaResource as
            com.pulumi.aws.dynamodb.TableItem,
    )
}

/**
 * @see [TableItem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TableItem].
 */
public suspend fun tableItem(name: String, block: suspend TableItemResourceBuilder.() -> Unit):
    TableItem {
    val builder = TableItemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TableItem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tableItem(name: String): TableItem {
    val builder = TableItemResourceBuilder()
    builder.name(name)
    return builder.build()
}
