@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.aws.dynamodb.TableItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DynamoDB table item resource
 * > **Note:** This resource is not meant to be used for managing large amounts of data in your table, it is not designed to scale.
 *   You should perform **regular backups** of all data in the table, see [AWS docs for more](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/BackupRestore.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.dynamodb.TableItem;
 * import com.pulumi.aws.dynamodb.TableItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleTable = new Table("exampleTable", TableArgs.builder()
 *             .readCapacity(10)
 *             .writeCapacity(10)
 *             .hashKey("exampleHashKey")
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("exampleHashKey")
 *                 .type("S")
 *                 .build())
 *             .build());
 *         var exampleTableItem = new TableItem("exampleTableItem", TableItemArgs.builder()
 *             .tableName(exampleTable.name())
 *             .hashKey(exampleTable.hashKey())
 *             .item("""
 * {
 *   "exampleHashKey": {"S": "something"},
 *   "one": {"N": "11111"},
 *   "two": {"N": "22222"},
 *   "three": {"N": "33333"},
 *   "four": {"N": "44444"}
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * You cannot import DynamoDB table items.
 * @property hashKey Hash key to use for lookups and identification of the item
 * @property item JSON representation of a map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.
 * @property rangeKey Range key to use for lookups and identification of the item. Required if there is range key defined in the table.
 * @property tableName Name of the table to contain the item.
 */
public data class TableItemArgs(
    public val hashKey: Output<String>? = null,
    public val item: Output<String>? = null,
    public val rangeKey: Output<String>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.TableItemArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.TableItemArgs =
        com.pulumi.aws.dynamodb.TableItemArgs.builder()
            .hashKey(hashKey?.applyValue({ args0 -> args0 }))
            .item(item?.applyValue({ args0 -> args0 }))
            .rangeKey(rangeKey?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableItemArgs].
 */
@PulumiTagMarker
public class TableItemArgsBuilder internal constructor() {
    private var hashKey: Output<String>? = null

    private var item: Output<String>? = null

    private var rangeKey: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value Hash key to use for lookups and identification of the item
     */
    @JvmName("qubsyopeoebpqmyc")
    public suspend fun hashKey(`value`: Output<String>) {
        this.hashKey = value
    }

    /**
     * @param value JSON representation of a map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.
     */
    @JvmName("svqkslbduwqwcenp")
    public suspend fun item(`value`: Output<String>) {
        this.item = value
    }

    /**
     * @param value Range key to use for lookups and identification of the item. Required if there is range key defined in the table.
     */
    @JvmName("xafpvpgctghtatll")
    public suspend fun rangeKey(`value`: Output<String>) {
        this.rangeKey = value
    }

    /**
     * @param value Name of the table to contain the item.
     */
    @JvmName("aqnmpnpycpdoleex")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value Hash key to use for lookups and identification of the item
     */
    @JvmName("xdvcdracmfwpvpel")
    public suspend fun hashKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hashKey = mapped
    }

    /**
     * @param value JSON representation of a map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.
     */
    @JvmName("iknfffxntiyvkyjo")
    public suspend fun item(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.item = mapped
    }

    /**
     * @param value Range key to use for lookups and identification of the item. Required if there is range key defined in the table.
     */
    @JvmName("kbtwmeatqggpsnap")
    public suspend fun rangeKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rangeKey = mapped
    }

    /**
     * @param value Name of the table to contain the item.
     */
    @JvmName("ixlorfvbpirwsvaw")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): TableItemArgs = TableItemArgs(
        hashKey = hashKey,
        item = item,
        rangeKey = rangeKey,
        tableName = tableName,
    )
}
