@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.aws.dynamodb.TableReplicaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DynamoDB table replica resource for [DynamoDB Global Tables V2 (version 2019&#46;11&#46;21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html).
 * > **Note:** Use `lifecycle` `ignore_changes` for `replica` in the associated aws.dynamodb.Table configuration.
 * > **Note:** Do not use the `replica` configuration block of aws.dynamodb.Table together with this resource as the two configuration options are mutually exclusive.
 * ## Example Usage
 * ### Basic Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.dynamodb.TableReplica;
 * import com.pulumi.aws.dynamodb.TableReplicaArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Provider("main", ProviderArgs.builder()
 *             .region("us-west-2")
 *             .build());
 *         var alt = new Provider("alt", ProviderArgs.builder()
 *             .region("us-east-2")
 *             .build());
 *         var exampleTable = new Table("exampleTable", TableArgs.builder()
 *             .hashKey("BrodoBaggins")
 *             .billingMode("PAY_PER_REQUEST")
 *             .streamEnabled(true)
 *             .streamViewType("NEW_AND_OLD_IMAGES")
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("BrodoBaggins")
 *                 .type("S")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.main())
 *                 .build());
 *         var exampleTableReplica = new TableReplica("exampleTableReplica", TableReplicaArgs.builder()
 *             .globalTableArn(exampleTable.arn())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "IZPAWS"),
 *                 Map.entry("Pozo", "Amargo")
 *             ))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.alt())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DynamoDB table replicas using the `table-name:main-region`. For example:
 * ~> __Note:__ When importing, use the region where the initial or _main_ global table resides, _not_ the region of the replica.
 * ```sh
 *  $ pulumi import aws:dynamodb/tableReplica:TableReplica example TestTable:us-west-2
 * ```
 * @property globalTableArn ARN of the _main_ or global table which this resource will replicate.
 * Optional arguments:
 * @property kmsKeyArn ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
 * @property pointInTimeRecovery Whether to enable Point In Time Recovery for the replica. Default is `false`.
 * @property tableClassOverride Storage class of the table replica. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`. If not used, the table replica will use the same class as the global table.
 * @property tags Map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class TableReplicaArgs(
    public val globalTableArn: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val pointInTimeRecovery: Output<Boolean>? = null,
    public val tableClassOverride: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.TableReplicaArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.TableReplicaArgs =
        com.pulumi.aws.dynamodb.TableReplicaArgs.builder()
            .globalTableArn(globalTableArn?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .pointInTimeRecovery(pointInTimeRecovery?.applyValue({ args0 -> args0 }))
            .tableClassOverride(tableClassOverride?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TableReplicaArgs].
 */
@PulumiTagMarker
public class TableReplicaArgsBuilder internal constructor() {
    private var globalTableArn: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    private var pointInTimeRecovery: Output<Boolean>? = null

    private var tableClassOverride: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ARN of the _main_ or global table which this resource will replicate.
     * Optional arguments:
     */
    @JvmName("ixybjecgfesnlgsy")
    public suspend fun globalTableArn(`value`: Output<String>) {
        this.globalTableArn = value
    }

    /**
     * @param value ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
     */
    @JvmName("akqwhvxpxxyljstv")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Whether to enable Point In Time Recovery for the replica. Default is `false`.
     */
    @JvmName("dxkuovauwbscmueq")
    public suspend fun pointInTimeRecovery(`value`: Output<Boolean>) {
        this.pointInTimeRecovery = value
    }

    /**
     * @param value Storage class of the table replica. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`. If not used, the table replica will use the same class as the global table.
     */
    @JvmName("xrfjpsuopejkbolu")
    public suspend fun tableClassOverride(`value`: Output<String>) {
        this.tableClassOverride = value
    }

    /**
     * @param value Map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sfrrppfbqkoacrni")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ARN of the _main_ or global table which this resource will replicate.
     * Optional arguments:
     */
    @JvmName("tfwqvkgwjwdrwnyf")
    public suspend fun globalTableArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalTableArn = mapped
    }

    /**
     * @param value ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
     */
    @JvmName("jhlsmmqovmdfrvgr")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value Whether to enable Point In Time Recovery for the replica. Default is `false`.
     */
    @JvmName("qugodbboijubhjym")
    public suspend fun pointInTimeRecovery(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pointInTimeRecovery = mapped
    }

    /**
     * @param value Storage class of the table replica. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`. If not used, the table replica will use the same class as the global table.
     */
    @JvmName("qxqouoshgrtqdjvh")
    public suspend fun tableClassOverride(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableClassOverride = mapped
    }

    /**
     * @param value Map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("olvhdlmabqvxosvf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("daespmavqiidrnsx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TableReplicaArgs = TableReplicaArgs(
        globalTableArn = globalTableArn,
        kmsKeyArn = kmsKeyArn,
        pointInTimeRecovery = pointInTimeRecovery,
        tableClassOverride = tableClassOverride,
        tags = tags,
    )
}
