@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin

import com.pulumi.aws.dynamodb.TagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an individual DynamoDB resource tag. This resource should only be used in cases where DynamoDB resources are created outside the provider (e.g., Table replicas in other regions).
 * > **NOTE:** This tagging resource should not be combined with the resource for managing the parent resource. For example, using `aws.dynamodb.Table` and `aws.dynamodb.Tag` to manage tags of the same DynamoDB Table in the same region will cause a perpetual difference where the `aws_dynamodb_cluster` resource will try to remove the tag being added by the `aws.dynamodb.Tag` resource.
 * > **NOTE:** This tagging resource does not use the provider `ignore_tags` configuration.
 * ## Import
 * Using `pulumi import`, import `aws_dynamodb_tag` using the DynamoDB resource identifier and key, separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:dynamodb/tag:Tag example arn:aws:dynamodb:us-east-1:123456789012:table/example,Name
 * ```
 * @property key Tag name.
 * @property resourceArn Amazon Resource Name (ARN) of the DynamoDB resource to tag.
 * @property value Tag value.
 */
public data class TagArgs(
    public val key: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.TagArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.TagArgs = com.pulumi.aws.dynamodb.TagArgs.builder()
        .key(key?.applyValue({ args0 -> args0 }))
        .resourceArn(resourceArn?.applyValue({ args0 -> args0 }))
        .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagArgs].
 */
@PulumiTagMarker
public class TagArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var resourceArn: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Tag name.
     */
    @JvmName("inhrejgocsomdevv")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the DynamoDB resource to tag.
     */
    @JvmName("dociviyjlnhnpkos")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value Tag value.
     */
    @JvmName("bivdxntdbpblebkl")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Tag name.
     */
    @JvmName("hxfhonjavrmnmwrl")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the DynamoDB resource to tag.
     */
    @JvmName("bmgupqdbfqrerxxn")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value Tag value.
     */
    @JvmName("xqdiqrhnrtnhbmbn")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TagArgs = TagArgs(
        key = key,
        resourceArn = resourceArn,
        `value` = `value`,
    )
}
