@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.GetTableServerSideEncryption.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled
 * @property kmsKeyArn
 */
public data class GetTableServerSideEncryption(
    public val enabled: Boolean,
    public val kmsKeyArn: String,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.GetTableServerSideEncryption> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.GetTableServerSideEncryption =
        com.pulumi.aws.dynamodb.inputs.GetTableServerSideEncryption.builder()
            .enabled(enabled.let({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTableServerSideEncryption].
 */
@PulumiTagMarker
public class GetTableServerSideEncryptionBuilder internal constructor() {
    private var enabled: Boolean? = null

    private var kmsKeyArn: String? = null

    /**
     * @param value
     */
    @JvmName("bpiljbqixrqsfbwb")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("iykpojtcdaxpyybk")
    public suspend fun kmsKeyArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kmsKeyArn = mapped
    }

    internal fun build(): GetTableServerSideEncryption = GetTableServerSideEncryption(
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        kmsKeyArn = kmsKeyArn ?: throw PulumiNullFieldException("kmsKeyArn"),
    )
}
