@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.GlobalTableReplicaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property regionName AWS region name of replica DynamoDB TableE.g., `us-east-1`
 */
public data class GlobalTableReplicaArgs(
    public val regionName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.GlobalTableReplicaArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.GlobalTableReplicaArgs =
        com.pulumi.aws.dynamodb.inputs.GlobalTableReplicaArgs.builder()
            .regionName(regionName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GlobalTableReplicaArgs].
 */
@PulumiTagMarker
public class GlobalTableReplicaArgsBuilder internal constructor() {
    private var regionName: Output<String>? = null

    /**
     * @param value AWS region name of replica DynamoDB TableE.g., `us-east-1`
     */
    @JvmName("nqnccuoonurfejrc")
    public suspend fun regionName(`value`: Output<String>) {
        this.regionName = value
    }

    /**
     * @param value AWS region name of replica DynamoDB TableE.g., `us-east-1`
     */
    @JvmName("dpxjmokoecteqxuo")
    public suspend fun regionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionName = mapped
    }

    internal fun build(): GlobalTableReplicaArgs = GlobalTableReplicaArgs(
        regionName = regionName ?: throw PulumiNullFieldException("regionName"),
    )
}
