@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.TableImportTableInputFormatOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property csv This block contains the processing options for the CSV file being imported:
 */
public data class TableImportTableInputFormatOptionsArgs(
    public val csv: Output<TableImportTableInputFormatOptionsCsvArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.TableImportTableInputFormatOptionsArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.TableImportTableInputFormatOptionsArgs =
        com.pulumi.aws.dynamodb.inputs.TableImportTableInputFormatOptionsArgs.builder()
            .csv(csv?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TableImportTableInputFormatOptionsArgs].
 */
@PulumiTagMarker
public class TableImportTableInputFormatOptionsArgsBuilder internal constructor() {
    private var csv: Output<TableImportTableInputFormatOptionsCsvArgs>? = null

    /**
     * @param value This block contains the processing options for the CSV file being imported:
     */
    @JvmName("xspvncpusukjmoll")
    public suspend fun csv(`value`: Output<TableImportTableInputFormatOptionsCsvArgs>) {
        this.csv = value
    }

    /**
     * @param value This block contains the processing options for the CSV file being imported:
     */
    @JvmName("wnfixychwejlldnl")
    public suspend fun csv(`value`: TableImportTableInputFormatOptionsCsvArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csv = mapped
    }

    /**
     * @param argument This block contains the processing options for the CSV file being imported:
     */
    @JvmName("dskqdfmgeiplehvm")
    public suspend
    fun csv(argument: suspend TableImportTableInputFormatOptionsCsvArgsBuilder.() -> Unit) {
        val toBeMapped = TableImportTableInputFormatOptionsCsvArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.csv = mapped
    }

    internal fun build(): TableImportTableInputFormatOptionsArgs =
        TableImportTableInputFormatOptionsArgs(
            csv = csv,
        )
}
