@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.TableImportTableInputFormatOptionsCsvArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property delimiter The delimiter used for separating items in the CSV file being imported.
 * @property headerLists List of the headers used to specify a common header for all source CSV files being imported.
 */
public data class TableImportTableInputFormatOptionsCsvArgs(
    public val delimiter: Output<String>? = null,
    public val headerLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.TableImportTableInputFormatOptionsCsvArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.TableImportTableInputFormatOptionsCsvArgs =
        com.pulumi.aws.dynamodb.inputs.TableImportTableInputFormatOptionsCsvArgs.builder()
            .delimiter(delimiter?.applyValue({ args0 -> args0 }))
            .headerLists(headerLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [TableImportTableInputFormatOptionsCsvArgs].
 */
@PulumiTagMarker
public class TableImportTableInputFormatOptionsCsvArgsBuilder internal constructor() {
    private var delimiter: Output<String>? = null

    private var headerLists: Output<List<String>>? = null

    /**
     * @param value The delimiter used for separating items in the CSV file being imported.
     */
    @JvmName("qooomcihugwnishf")
    public suspend fun delimiter(`value`: Output<String>) {
        this.delimiter = value
    }

    /**
     * @param value List of the headers used to specify a common header for all source CSV files being imported.
     */
    @JvmName("kqjkkayldiceehwh")
    public suspend fun headerLists(`value`: Output<List<String>>) {
        this.headerLists = value
    }

    @JvmName("rbnjybqebrlsgqhj")
    public suspend fun headerLists(vararg values: Output<String>) {
        this.headerLists = Output.all(values.asList())
    }

    /**
     * @param values List of the headers used to specify a common header for all source CSV files being imported.
     */
    @JvmName("acltqqcbljivphlh")
    public suspend fun headerLists(values: List<Output<String>>) {
        this.headerLists = Output.all(values)
    }

    /**
     * @param value The delimiter used for separating items in the CSV file being imported.
     */
    @JvmName("pxdkcgcpgorhekng")
    public suspend fun delimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delimiter = mapped
    }

    /**
     * @param value List of the headers used to specify a common header for all source CSV files being imported.
     */
    @JvmName("ewasfpqcwibxcyec")
    public suspend fun headerLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerLists = mapped
    }

    /**
     * @param values List of the headers used to specify a common header for all source CSV files being imported.
     */
    @JvmName("sbdtiklnsjfsqxuv")
    public suspend fun headerLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerLists = mapped
    }

    internal fun build(): TableImportTableInputFormatOptionsCsvArgs =
        TableImportTableInputFormatOptionsCsvArgs(
            delimiter = delimiter,
            headerLists = headerLists,
        )
}
