@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.TableImportTableS3BucketSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket The S3 bucket that is being imported from.
 * @property bucketOwner The account number of the S3 bucket that is being imported from.
 * @property keyPrefix The key prefix shared by all S3 Objects that are being imported.
 */
public data class TableImportTableS3BucketSourceArgs(
    public val bucket: Output<String>,
    public val bucketOwner: Output<String>? = null,
    public val keyPrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.TableImportTableS3BucketSourceArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.TableImportTableS3BucketSourceArgs =
        com.pulumi.aws.dynamodb.inputs.TableImportTableS3BucketSourceArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .bucketOwner(bucketOwner?.applyValue({ args0 -> args0 }))
            .keyPrefix(keyPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableImportTableS3BucketSourceArgs].
 */
@PulumiTagMarker
public class TableImportTableS3BucketSourceArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var bucketOwner: Output<String>? = null

    private var keyPrefix: Output<String>? = null

    /**
     * @param value The S3 bucket that is being imported from.
     */
    @JvmName("eqtqfwajsiouneff")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The account number of the S3 bucket that is being imported from.
     */
    @JvmName("lacykgyecrquxiad")
    public suspend fun bucketOwner(`value`: Output<String>) {
        this.bucketOwner = value
    }

    /**
     * @param value The key prefix shared by all S3 Objects that are being imported.
     */
    @JvmName("yglmvvamwxvqcgty")
    public suspend fun keyPrefix(`value`: Output<String>) {
        this.keyPrefix = value
    }

    /**
     * @param value The S3 bucket that is being imported from.
     */
    @JvmName("rmeihqcnrvetmlgl")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The account number of the S3 bucket that is being imported from.
     */
    @JvmName("pinpxlhaxltottfa")
    public suspend fun bucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketOwner = mapped
    }

    /**
     * @param value The key prefix shared by all S3 Objects that are being imported.
     */
    @JvmName("kkfqkywegcsowtyr")
    public suspend fun keyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPrefix = mapped
    }

    internal fun build(): TableImportTableS3BucketSourceArgs = TableImportTableS3BucketSourceArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
        bucketOwner = bucketOwner,
        keyPrefix = keyPrefix,
    )
}
