@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.TableLocalSecondaryIndexArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the index
 * @property nonKeyAttributes Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
 * @property projectionType One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
 * @property rangeKey Name of the range key.
 */
public data class TableLocalSecondaryIndexArgs(
    public val name: Output<String>,
    public val nonKeyAttributes: Output<List<String>>? = null,
    public val projectionType: Output<String>,
    public val rangeKey: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.TableLocalSecondaryIndexArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.TableLocalSecondaryIndexArgs =
        com.pulumi.aws.dynamodb.inputs.TableLocalSecondaryIndexArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .nonKeyAttributes(nonKeyAttributes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .projectionType(projectionType.applyValue({ args0 -> args0 }))
            .rangeKey(rangeKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableLocalSecondaryIndexArgs].
 */
@PulumiTagMarker
public class TableLocalSecondaryIndexArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var nonKeyAttributes: Output<List<String>>? = null

    private var projectionType: Output<String>? = null

    private var rangeKey: Output<String>? = null

    /**
     * @param value Name of the index
     */
    @JvmName("nckpmvrcmtvirywc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
     */
    @JvmName("cutlkvtblnokyads")
    public suspend fun nonKeyAttributes(`value`: Output<List<String>>) {
        this.nonKeyAttributes = value
    }

    @JvmName("rvwmstxvhluqgkvn")
    public suspend fun nonKeyAttributes(vararg values: Output<String>) {
        this.nonKeyAttributes = Output.all(values.asList())
    }

    /**
     * @param values Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
     */
    @JvmName("odfnfmtoorkwvcbd")
    public suspend fun nonKeyAttributes(values: List<Output<String>>) {
        this.nonKeyAttributes = Output.all(values)
    }

    /**
     * @param value One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
     */
    @JvmName("khigqjqdgbkrjkkg")
    public suspend fun projectionType(`value`: Output<String>) {
        this.projectionType = value
    }

    /**
     * @param value Name of the range key.
     */
    @JvmName("aplxeehvtnkqnopo")
    public suspend fun rangeKey(`value`: Output<String>) {
        this.rangeKey = value
    }

    /**
     * @param value Name of the index
     */
    @JvmName("dceiggugejtcopcc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
     */
    @JvmName("ugcrhjfwxvralqrp")
    public suspend fun nonKeyAttributes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nonKeyAttributes = mapped
    }

    /**
     * @param values Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
     */
    @JvmName("yimepgbmrfoawqla")
    public suspend fun nonKeyAttributes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nonKeyAttributes = mapped
    }

    /**
     * @param value One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
     */
    @JvmName("spchrxqoyqqvkgwn")
    public suspend fun projectionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectionType = mapped
    }

    /**
     * @param value Name of the range key.
     */
    @JvmName("grqeyquifqglmofr")
    public suspend fun rangeKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rangeKey = mapped
    }

    internal fun build(): TableLocalSecondaryIndexArgs = TableLocalSecondaryIndexArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        nonKeyAttributes = nonKeyAttributes,
        projectionType = projectionType ?: throw PulumiNullFieldException("projectionType"),
        rangeKey = rangeKey ?: throw PulumiNullFieldException("rangeKey"),
    )
}
