@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.TablePointInTimeRecoveryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether to enable point-in-time recovery. It can take 10 minutes to enable for new tables. If the `point_in_time_recovery` block is not provided, this defaults to `false`.
 */
public data class TablePointInTimeRecoveryArgs(
    public val enabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.TablePointInTimeRecoveryArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.TablePointInTimeRecoveryArgs =
        com.pulumi.aws.dynamodb.inputs.TablePointInTimeRecoveryArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TablePointInTimeRecoveryArgs].
 */
@PulumiTagMarker
public class TablePointInTimeRecoveryArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether to enable point-in-time recovery. It can take 10 minutes to enable for new tables. If the `point_in_time_recovery` block is not provided, this defaults to `false`.
     */
    @JvmName("osignjdpyxgsvnii")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether to enable point-in-time recovery. It can take 10 minutes to enable for new tables. If the `point_in_time_recovery` block is not provided, this defaults to `false`.
     */
    @JvmName("wgrkbphqkavnmkaj")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): TablePointInTimeRecoveryArgs = TablePointInTimeRecoveryArgs(
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
    )
}
