@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.inputs

import com.pulumi.aws.dynamodb.inputs.TableReplicaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn ARN of the table
 * @property kmsKeyArn ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
 * @property pointInTimeRecovery Whether to enable Point In Time Recovery for the replica. Default is `false`.
 * @property propagateTags Whether to propagate the global table's tags to a replica. Default is `false`. Changes to tags only move in one direction: from global (source) to replica. In other words, tag drift on a replica will not trigger an update. Tag or replica changes on the global table, whether from drift or configuration changes, are propagated to replicas. Changing from `true` to `false` on a subsequent `apply` means replica tags are left as they were, unmanaged, not deleted.
 * @property regionName Region name of the replica.
 * @property streamArn ARN of the Table Stream. Only available when `stream_enabled = true`
 * @property streamLabel Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
 */
public data class TableReplicaArgs(
    public val arn: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val pointInTimeRecovery: Output<Boolean>? = null,
    public val propagateTags: Output<Boolean>? = null,
    public val regionName: Output<String>,
    public val streamArn: Output<String>? = null,
    public val streamLabel: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dynamodb.inputs.TableReplicaArgs> {
    override fun toJava(): com.pulumi.aws.dynamodb.inputs.TableReplicaArgs =
        com.pulumi.aws.dynamodb.inputs.TableReplicaArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .pointInTimeRecovery(pointInTimeRecovery?.applyValue({ args0 -> args0 }))
            .propagateTags(propagateTags?.applyValue({ args0 -> args0 }))
            .regionName(regionName.applyValue({ args0 -> args0 }))
            .streamArn(streamArn?.applyValue({ args0 -> args0 }))
            .streamLabel(streamLabel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableReplicaArgs].
 */
@PulumiTagMarker
public class TableReplicaArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    private var pointInTimeRecovery: Output<Boolean>? = null

    private var propagateTags: Output<Boolean>? = null

    private var regionName: Output<String>? = null

    private var streamArn: Output<String>? = null

    private var streamLabel: Output<String>? = null

    /**
     * @param value ARN of the table
     */
    @JvmName("tmvdfixymdtmajfo")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
     */
    @JvmName("frykfceljbhfitoe")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Whether to enable Point In Time Recovery for the replica. Default is `false`.
     */
    @JvmName("ebpyeeqbkqarmbva")
    public suspend fun pointInTimeRecovery(`value`: Output<Boolean>) {
        this.pointInTimeRecovery = value
    }

    /**
     * @param value Whether to propagate the global table's tags to a replica. Default is `false`. Changes to tags only move in one direction: from global (source) to replica. In other words, tag drift on a replica will not trigger an update. Tag or replica changes on the global table, whether from drift or configuration changes, are propagated to replicas. Changing from `true` to `false` on a subsequent `apply` means replica tags are left as they were, unmanaged, not deleted.
     */
    @JvmName("jtuoxxtusckjoexa")
    public suspend fun propagateTags(`value`: Output<Boolean>) {
        this.propagateTags = value
    }

    /**
     * @param value Region name of the replica.
     */
    @JvmName("ofqomtitqwgjutlw")
    public suspend fun regionName(`value`: Output<String>) {
        this.regionName = value
    }

    /**
     * @param value ARN of the Table Stream. Only available when `stream_enabled = true`
     */
    @JvmName("admqjrrbhllrwgxw")
    public suspend fun streamArn(`value`: Output<String>) {
        this.streamArn = value
    }

    /**
     * @param value Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
     */
    @JvmName("rxpdrjgeiqeqraqt")
    public suspend fun streamLabel(`value`: Output<String>) {
        this.streamLabel = value
    }

    /**
     * @param value ARN of the table
     */
    @JvmName("jrqhsiyfolrcdmed")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
     */
    @JvmName("gfveddjhhrxxaqcu")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value Whether to enable Point In Time Recovery for the replica. Default is `false`.
     */
    @JvmName("ottecsgpgpoatpbg")
    public suspend fun pointInTimeRecovery(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pointInTimeRecovery = mapped
    }

    /**
     * @param value Whether to propagate the global table's tags to a replica. Default is `false`. Changes to tags only move in one direction: from global (source) to replica. In other words, tag drift on a replica will not trigger an update. Tag or replica changes on the global table, whether from drift or configuration changes, are propagated to replicas. Changing from `true` to `false` on a subsequent `apply` means replica tags are left as they were, unmanaged, not deleted.
     */
    @JvmName("nptktxmjrgcfflsi")
    public suspend fun propagateTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propagateTags = mapped
    }

    /**
     * @param value Region name of the replica.
     */
    @JvmName("fdoddgurllbdwmjm")
    public suspend fun regionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionName = mapped
    }

    /**
     * @param value ARN of the Table Stream. Only available when `stream_enabled = true`
     */
    @JvmName("cyiujhywwlaiamgb")
    public suspend fun streamArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamArn = mapped
    }

    /**
     * @param value Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
     */
    @JvmName("mswjadojkfonwmwd")
    public suspend fun streamLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamLabel = mapped
    }

    internal fun build(): TableReplicaArgs = TableReplicaArgs(
        arn = arn,
        kmsKeyArn = kmsKeyArn,
        pointInTimeRecovery = pointInTimeRecovery,
        propagateTags = propagateTags,
        regionName = regionName ?: throw PulumiNullFieldException("regionName"),
        streamArn = streamArn,
        streamLabel = streamLabel,
    )
}
