@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property hashKey
 * @property name Name of the DynamoDB table.
 * @property nonKeyAttributes
 * @property projectionType
 * @property rangeKey
 * @property readCapacity
 * @property writeCapacity
 */
public data class GetTableGlobalSecondaryIndex(
    public val hashKey: String,
    public val name: String,
    public val nonKeyAttributes: List<String>,
    public val projectionType: String,
    public val rangeKey: String,
    public val readCapacity: Int,
    public val writeCapacity: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dynamodb.outputs.GetTableGlobalSecondaryIndex):
            GetTableGlobalSecondaryIndex = GetTableGlobalSecondaryIndex(
            hashKey = javaType.hashKey(),
            name = javaType.name(),
            nonKeyAttributes = javaType.nonKeyAttributes().map({ args0 -> args0 }),
            projectionType = javaType.projectionType(),
            rangeKey = javaType.rangeKey(),
            readCapacity = javaType.readCapacity(),
            writeCapacity = javaType.writeCapacity(),
        )
    }
}
