@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name Name of the attribute
 * @property type Attribute type. Valid values are `S` (string), `N` (number), `B` (binary).
 */
public data class TableAttribute(
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dynamodb.outputs.TableAttribute): TableAttribute =
            TableAttribute(
                name = javaType.name(),
                type = javaType.type(),
            )
    }
}
