@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property hashKey Name of the hash key in the index; must be defined as an attribute in the resource.
 * @property name Name of the index.
 * @property nonKeyAttributes Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
 * @property projectionType One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
 * @property rangeKey Name of the range key; must be defined
 * @property readCapacity Number of read units for this index. Must be set if billing_mode is set to PROVISIONED.
 * @property writeCapacity Number of write units for this index. Must be set if billing_mode is set to PROVISIONED.
 */
public data class TableGlobalSecondaryIndex(
    public val hashKey: String,
    public val name: String,
    public val nonKeyAttributes: List<String>? = null,
    public val projectionType: String,
    public val rangeKey: String? = null,
    public val readCapacity: Int? = null,
    public val writeCapacity: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dynamodb.outputs.TableGlobalSecondaryIndex):
            TableGlobalSecondaryIndex = TableGlobalSecondaryIndex(
            hashKey = javaType.hashKey(),
            name = javaType.name(),
            nonKeyAttributes = javaType.nonKeyAttributes().map({ args0 -> args0 }),
            projectionType = javaType.projectionType(),
            rangeKey = javaType.rangeKey().map({ args0 -> args0 }).orElse(null),
            readCapacity = javaType.readCapacity().map({ args0 -> args0 }).orElse(null),
            writeCapacity = javaType.writeCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
